/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ProviderOperationsMetadatas.
 */
public class ProviderOperationsMetadatasInner {
    /** The Retrofit service to perform REST calls. */
    private ProviderOperationsMetadatasService service;
    /** The service client containing this operation class. */
    private AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of ProviderOperationsMetadatasInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ProviderOperationsMetadatasInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = retrofit.create(ProviderOperationsMetadatasService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ProviderOperationsMetadatas to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ProviderOperationsMetadatasService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ProviderOperationsMetadatas get" })
        @GET("providers/Microsoft.Authorization/providerOperations/{resourceProviderNamespace}")
        Observable<Response<ResponseBody>> get(@Path("resourceProviderNamespace") String resourceProviderNamespace, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ProviderOperationsMetadatas list" })
        @GET("providers/Microsoft.Authorization/providerOperations")
        Observable<Response<ResponseBody>> list(@Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ProviderOperationsMetadatas listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProviderOperationsMetadataInner object if successful.
     */
    public ProviderOperationsMetadataInner get(String resourceProviderNamespace, String apiVersion) {
        return getWithServiceResponseAsync(resourceProviderNamespace, apiVersion).toBlocking().single().body();
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion, final ServiceCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceProviderNamespace, apiVersion), serviceCallback);
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProviderOperationsMetadataInner object
     */
    public Observable<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion) {
        return getWithServiceResponseAsync(resourceProviderNamespace, apiVersion).map(new Func1<ServiceResponse<ProviderOperationsMetadataInner>, ProviderOperationsMetadataInner>() {
            @Override
            public ProviderOperationsMetadataInner call(ServiceResponse<ProviderOperationsMetadataInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProviderOperationsMetadataInner object
     */
    public Observable<ServiceResponse<ProviderOperationsMetadataInner>> getWithServiceResponseAsync(String resourceProviderNamespace, String apiVersion) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        final String expand = null;
        return service.get(resourceProviderNamespace, apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderOperationsMetadataInner>>>() {
                @Override
                public Observable<ServiceResponse<ProviderOperationsMetadataInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProviderOperationsMetadataInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProviderOperationsMetadataInner object if successful.
     */
    public ProviderOperationsMetadataInner get(String resourceProviderNamespace, String apiVersion, String expand) {
        return getWithServiceResponseAsync(resourceProviderNamespace, apiVersion, expand).toBlocking().single().body();
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @param expand Specifies whether to expand the values.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion, String expand, final ServiceCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceProviderNamespace, apiVersion, expand), serviceCallback);
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProviderOperationsMetadataInner object
     */
    public Observable<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion, String expand) {
        return getWithServiceResponseAsync(resourceProviderNamespace, apiVersion, expand).map(new Func1<ServiceResponse<ProviderOperationsMetadataInner>, ProviderOperationsMetadataInner>() {
            @Override
            public ProviderOperationsMetadataInner call(ServiceResponse<ProviderOperationsMetadataInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets provider operations metadata for the specified resource provider.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param apiVersion The API version to use for the operation.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProviderOperationsMetadataInner object
     */
    public Observable<ServiceResponse<ProviderOperationsMetadataInner>> getWithServiceResponseAsync(String resourceProviderNamespace, String apiVersion, String expand) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return service.get(resourceProviderNamespace, apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderOperationsMetadataInner>>>() {
                @Override
                public Observable<ServiceResponse<ProviderOperationsMetadataInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProviderOperationsMetadataInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProviderOperationsMetadataInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProviderOperationsMetadataInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProviderOperationsMetadataInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProviderOperationsMetadataInner&gt; object if successful.
     */
    public PagedList<ProviderOperationsMetadataInner> list(final String apiVersion) {
        ServiceResponse<Page<ProviderOperationsMetadataInner>> response = listSinglePageAsync(apiVersion).toBlocking().single();
        return new PagedList<ProviderOperationsMetadataInner>(response.body()) {
            @Override
            public Page<ProviderOperationsMetadataInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProviderOperationsMetadataInner>> listAsync(final String apiVersion, final ListOperationCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(apiVersion),
            new Func1<String, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProviderOperationsMetadataInner&gt; object
     */
    public Observable<Page<ProviderOperationsMetadataInner>> listAsync(final String apiVersion) {
        return listWithServiceResponseAsync(apiVersion)
            .map(new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Page<ProviderOperationsMetadataInner>>() {
                @Override
                public Page<ProviderOperationsMetadataInner> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProviderOperationsMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listWithServiceResponseAsync(final String apiVersion) {
        return listSinglePageAsync(apiVersion)
            .concatMap(new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProviderOperationsMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listSinglePageAsync(final String apiVersion) {
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        final String expand = null;
        return service.list(apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProviderOperationsMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProviderOperationsMetadataInner&gt; object if successful.
     */
    public PagedList<ProviderOperationsMetadataInner> list(final String apiVersion, final String expand) {
        ServiceResponse<Page<ProviderOperationsMetadataInner>> response = listSinglePageAsync(apiVersion, expand).toBlocking().single();
        return new PagedList<ProviderOperationsMetadataInner>(response.body()) {
            @Override
            public Page<ProviderOperationsMetadataInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @param expand Specifies whether to expand the values.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProviderOperationsMetadataInner>> listAsync(final String apiVersion, final String expand, final ListOperationCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(apiVersion, expand),
            new Func1<String, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProviderOperationsMetadataInner&gt; object
     */
    public Observable<Page<ProviderOperationsMetadataInner>> listAsync(final String apiVersion, final String expand) {
        return listWithServiceResponseAsync(apiVersion, expand)
            .map(new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Page<ProviderOperationsMetadataInner>>() {
                @Override
                public Page<ProviderOperationsMetadataInner> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param apiVersion The API version to use for this operation.
     * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProviderOperationsMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listWithServiceResponseAsync(final String apiVersion, final String expand) {
        return listSinglePageAsync(apiVersion, expand)
            .concatMap(new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
    ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> * @param apiVersion The API version to use for this operation.
    ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> * @param expand Specifies whether to expand the values.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProviderOperationsMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listSinglePageAsync(final String apiVersion, final String expand) {
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return service.list(apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProviderOperationsMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ProviderOperationsMetadataInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ProviderOperationsMetadataInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProviderOperationsMetadataInner&gt; object if successful.
     */
    public PagedList<ProviderOperationsMetadataInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ProviderOperationsMetadataInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProviderOperationsMetadataInner>(response.body()) {
            @Override
            public Page<ProviderOperationsMetadataInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProviderOperationsMetadataInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ProviderOperationsMetadataInner>> serviceFuture, final ListOperationCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProviderOperationsMetadataInner&gt; object
     */
    public Observable<Page<ProviderOperationsMetadataInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Page<ProviderOperationsMetadataInner>>() {
                @Override
                public Page<ProviderOperationsMetadataInner> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProviderOperationsMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets provider operations metadata for all resource providers.
     *
    ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProviderOperationsMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProviderOperationsMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ProviderOperationsMetadataInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ProviderOperationsMetadataInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
