/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroup;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUser;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.RoleAssignmentPropertiesWithScope;
import com.microsoft.azure.management.graphrbac.RoleDefinition;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentInner;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentPropertiesInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class RoleAssignmentImpl
extends CreatableImpl<RoleAssignment, RoleAssignmentInner, RoleAssignmentImpl>
implements RoleAssignment,
RoleAssignment.Definition {
    private GraphRbacManager manager;
    private String objectId;
    private String userName;
    private String servicePrincipalName;
    private String roleDefinitionId;
    private String roleName;

    RoleAssignmentImpl(RoleAssignmentInner innerObject, GraphRbacManager manager) {
        super(innerObject.name(), (Object)innerObject);
        this.manager = manager;
    }

    public String id() {
        return ((RoleAssignmentInner)this.inner()).id();
    }

    public boolean isInCreateMode() {
        return ((RoleAssignmentInner)this.inner()).id() == null;
    }

    public Observable<RoleAssignment> createResourceAsync() {
        Observable roleDefinitionIdObservable;
        Observable objectIdObservable;
        if (this.objectId != null) {
            objectIdObservable = Observable.just((Object)this.objectId);
        } else if (this.userName != null) {
            objectIdObservable = this.manager.users().getByNameAsync(this.userName).map((Func1)new Func1<ActiveDirectoryUser, String>(){

                public String call(ActiveDirectoryUser user) {
                    return user.id();
                }
            });
        } else if (this.servicePrincipalName != null) {
            objectIdObservable = this.manager.servicePrincipals().getByNameAsync(this.servicePrincipalName).map((Func1)new Func1<ServicePrincipal, String>(){

                public String call(ServicePrincipal sp) {
                    return sp.id();
                }
            });
        } else {
            throw new IllegalArgumentException("Please pass a non-null value for either object Id, user, group, or service principal");
        }
        if (this.roleDefinitionId != null) {
            roleDefinitionIdObservable = Observable.just((Object)this.roleDefinitionId);
        } else if (this.roleName != null) {
            roleDefinitionIdObservable = this.manager().roleDefinitions().getByScopeAndRoleNameAsync(this.scope(), this.roleName).map((Func1)new Func1<RoleDefinition, String>(){

                public String call(RoleDefinition roleDefinition) {
                    return roleDefinition.id();
                }
            });
        } else {
            throw new IllegalArgumentException("Please pass a non-null value for either role name or role definition ID");
        }
        return Observable.zip((Observable)objectIdObservable, (Observable)roleDefinitionIdObservable, (Func2)new Func2<String, String, RoleAssignmentPropertiesInner>(){

            public RoleAssignmentPropertiesInner call(String objectId, String roleDefinitionId) {
                return new RoleAssignmentPropertiesInner().withPrincipalId(objectId).withRoleDefinitionId(roleDefinitionId);
            }
        }).flatMap((Func1)new Func1<RoleAssignmentPropertiesInner, Observable<RoleAssignmentInner>>(){

            public Observable<RoleAssignmentInner> call(RoleAssignmentPropertiesInner roleAssignmentPropertiesInner) {
                return RoleAssignmentImpl.this.manager().roleInner().roleAssignments().createAsync(RoleAssignmentImpl.this.scope(), RoleAssignmentImpl.this.name(), roleAssignmentPropertiesInner).retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

                    public Observable<?> call(Observable<? extends Throwable> observable) {
                        return observable.zipWith(Observable.range((int)1, (int)30), (Func2)new Func2<Throwable, Integer, Integer>(){

                            public Integer call(Throwable throwable, Integer integer) {
                                if (throwable instanceof CloudException && ((CloudException)throwable).body().code().equalsIgnoreCase("PrincipalNotFound")) {
                                    return integer;
                                }
                                throw Exceptions.propagate((Throwable)throwable);
                            }
                        }).flatMap(new Func1<Integer, Observable<?>>(){

                            public Observable<?> call(Integer i) {
                                return Observable.timer((long)i.intValue(), (TimeUnit)TimeUnit.SECONDS);
                            }
                        });
                    }
                });
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<RoleAssignmentInner> getInnerAsync() {
        return this.manager.roleInner().roleAssignments().getAsync(this.scope(), this.name());
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    @Override
    public String scope() {
        if (((RoleAssignmentInner)this.inner()).properties() == null) {
            return null;
        }
        return ((RoleAssignmentInner)this.inner()).properties().scope();
    }

    @Override
    public String roleDefinitionId() {
        if (((RoleAssignmentInner)this.inner()).properties() == null) {
            return null;
        }
        return ((RoleAssignmentInner)this.inner()).properties().roleDefinitionId();
    }

    @Override
    public String principalId() {
        if (((RoleAssignmentInner)this.inner()).properties() == null) {
            return null;
        }
        return ((RoleAssignmentInner)this.inner()).properties().principalId();
    }

    @Override
    public RoleAssignmentImpl forObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @Override
    public RoleAssignmentImpl forUser(ActiveDirectoryUser user) {
        this.objectId = user.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forUser(String name) {
        this.userName = name;
        return this;
    }

    @Override
    public RoleAssignmentImpl forGroup(ActiveDirectoryGroup activeDirectoryGroup) {
        this.objectId = activeDirectoryGroup.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forServicePrincipal(ServicePrincipal servicePrincipal) {
        this.objectId = servicePrincipal.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forServicePrincipal(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
        return this;
    }

    @Override
    public RoleAssignmentImpl withBuiltInRole(BuiltInRole role) {
        this.roleName = role.toString();
        return this;
    }

    @Override
    public RoleAssignmentImpl withRoleDefinition(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    @Override
    public RoleAssignmentImpl withScope(String scope) {
        if (((RoleAssignmentInner)this.inner()).properties() == null) {
            ((RoleAssignmentInner)this.inner()).withProperties(new RoleAssignmentPropertiesWithScope());
        }
        ((RoleAssignmentInner)this.inner()).properties().withScope(scope);
        return this;
    }

    @Override
    public RoleAssignmentImpl withResourceGroupScope(ResourceGroup resourceGroup) {
        return this.withScope(resourceGroup.id());
    }

    @Override
    public RoleAssignmentImpl withResourceScope(Resource resource) {
        return this.withScope(resource.id());
    }

    @Override
    public RoleAssignmentImpl withSubscriptionScope(String subscriptionId) {
        return this.withScope("subscriptions/" + subscriptionId);
    }
}

