/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroup;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.User;
import com.microsoft.azure.management.keyvault.AccessPolicy;
import com.microsoft.azure.management.keyvault.AccessPolicyEntry;
import com.microsoft.azure.management.keyvault.KeyPermissions;
import com.microsoft.azure.management.keyvault.Permissions;
import com.microsoft.azure.management.keyvault.SecretPermissions;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.implementation.VaultImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@LangDefinition
class AccessPolicyImpl
extends ChildResourceImpl<AccessPolicyEntry, VaultImpl, Vault>
implements AccessPolicy,
AccessPolicy.Definition<Vault.DefinitionStages.WithCreate>,
AccessPolicy.UpdateDefinition<Vault.Update>,
AccessPolicy.Update {
    private String userPrincipalName;
    private String servicePrincipalName;

    AccessPolicyImpl(AccessPolicyEntry innerObject, VaultImpl parent) {
        super((Object)innerObject, (Object)parent);
        ((AccessPolicyEntry)this.inner()).withTenantId(UUID.fromString(parent.tenantId()));
    }

    String userPrincipalName() {
        return this.userPrincipalName;
    }

    String servicePrincipalName() {
        return this.servicePrincipalName;
    }

    @Override
    public String tenantId() {
        if (((AccessPolicyEntry)this.inner()).tenantId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.inner()).tenantId().toString();
    }

    @Override
    public String objectId() {
        if (((AccessPolicyEntry)this.inner()).objectId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.inner()).objectId().toString();
    }

    @Override
    public String applicationId() {
        if (((AccessPolicyEntry)this.inner()).applicationId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.inner()).applicationId().toString();
    }

    @Override
    public Permissions permissions() {
        return ((AccessPolicyEntry)this.inner()).permissions();
    }

    public String name() {
        return ((AccessPolicyEntry)this.inner()).objectId().toString();
    }

    private void initializeKeyPermissions() {
        if (((AccessPolicyEntry)this.inner()).permissions() == null) {
            ((AccessPolicyEntry)this.inner()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.inner()).permissions().keys() == null) {
            ((AccessPolicyEntry)this.inner()).permissions().withKeys(new ArrayList<KeyPermissions>());
        }
    }

    private void initializeSecretPermissions() {
        if (((AccessPolicyEntry)this.inner()).permissions() == null) {
            ((AccessPolicyEntry)this.inner()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.inner()).permissions().secrets() == null) {
            ((AccessPolicyEntry)this.inner()).permissions().withSecrets(new ArrayList<SecretPermissions>());
        }
    }

    @Override
    public AccessPolicyImpl allowKeyPermissions(KeyPermissions ... permissions) {
        this.initializeKeyPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().addAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl allowKeyPermissions(List<KeyPermissions> permissions) {
        this.initializeKeyPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().addAll(permissions);
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretPermissions(SecretPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().addAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretPermissions(List<SecretPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().addAll(permissions);
        return this;
    }

    public VaultImpl attach() {
        ((VaultImpl)this.parent()).withAccessPolicy(this);
        return (VaultImpl)this.parent();
    }

    public AccessPolicyImpl forObjectId(UUID objectId) {
        ((AccessPolicyEntry)this.inner()).withObjectId(objectId);
        return this;
    }

    public AccessPolicyImpl forUser(User user) {
        ((AccessPolicyEntry)this.inner()).withObjectId(UUID.fromString(user.objectId()));
        return this;
    }

    public AccessPolicyImpl forUser(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public AccessPolicyImpl forGroup(ActiveDirectoryGroup group) {
        ((AccessPolicyEntry)this.inner()).withObjectId(UUID.fromString(group.objectId()));
        return this;
    }

    public AccessPolicyImpl forServicePrincipal(ServicePrincipal servicePrincipal) {
        ((AccessPolicyEntry)this.inner()).withObjectId(UUID.fromString(servicePrincipal.objectId()));
        return this;
    }

    public AccessPolicyImpl forServicePrincipal(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
        return this;
    }

    @Override
    public AccessPolicyImpl allowKeyAllPermissions() {
        return this.allowKeyPermissions(KeyPermissions.ALL);
    }

    @Override
    public AccessPolicyImpl disallowKeyAllPermissions() {
        this.initializeKeyPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyPermissions(KeyPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyPermissions(List<KeyPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().removeAll(permissions);
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretAllPermissions() {
        return this.allowSecretPermissions(SecretPermissions.ALL);
    }

    @Override
    public AccessPolicyImpl disallowSecretAllPermissions() {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretPermissions(SecretPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretPermissions(List<SecretPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().removeAll(permissions);
        return this;
    }
}

