/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.RequestIdHeaderInterceptor;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.Vaults;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultsImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import okhttp3.Interceptor;

public final class KeyVaultManager
extends Manager<KeyVaultManager, KeyVaultManagementClientImpl> {
    private GraphRbacManager graphRbacManager;
    private Vaults vaults;
    private final String tenantId;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static KeyVaultManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new KeyVaultManager(credentials.getEnvironment().newRestClientBuilder().withCredentials((ServiceClientCredentials)credentials).build(), credentials.getDomain(), subscriptionId);
    }

    public static KeyVaultManager authenticate(RestClient restClient, String tenantId, String subscriptionId) {
        return new KeyVaultManager(restClient, tenantId, subscriptionId);
    }

    private KeyVaultManager(RestClient restClient, String tenantId, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new KeyVaultManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        String graphEndpoint = AzureEnvironment.AZURE.getGraphEndpoint();
        if (restClient.credentials() instanceof AzureTokenCredentials) {
            graphEndpoint = ((AzureTokenCredentials)restClient.credentials()).getEnvironment().getGraphEndpoint();
        }
        this.graphRbacManager = GraphRbacManager.authenticate((RestClient)new RestClient.Builder().withBaseUrl(graphEndpoint).withInterceptor((Interceptor)new RequestIdHeaderInterceptor()).withCredentials(restClient.credentials()).build(), (String)tenantId);
        this.tenantId = tenantId;
    }

    public Vaults vaults() {
        if (this.vaults == null) {
            this.vaults = new VaultsImpl(((KeyVaultManagementClientImpl)((Object)this.innerManagementClient)).vaults(), this, this.graphRbacManager, this.tenantId);
        }
        return this.vaults;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public KeyVaultManager authenticate(AzureTokenCredentials credentials, String tenantId, String subscriptionId) {
            return KeyVaultManager.authenticate(this.buildRestClient(credentials), tenantId, subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public KeyVaultManager authenticate(AzureTokenCredentials var1, String var2, String var3);
    }
}

