/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.User;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.AccessPolicy;
import com.microsoft.azure.management.keyvault.AccessPolicyEntry;
import com.microsoft.azure.management.keyvault.Sku;
import com.microsoft.azure.management.keyvault.SkuName;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.VaultProperties;
import com.microsoft.azure.management.keyvault.implementation.AccessPolicyImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.VaultCreateOrUpdateParametersInner;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.keyvault.implementation.VaultsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.FuncN;
import rx.schedulers.Schedulers;

@LangDefinition
class VaultImpl
extends GroupableResourceImpl<Vault, VaultInner, VaultImpl, KeyVaultManager>
implements Vault,
Vault.Definition,
Vault.Update {
    private VaultsInner client;
    private GraphRbacManager graphRbacManager;
    private List<AccessPolicyImpl> accessPolicies;

    VaultImpl(String key, VaultInner innerObject, VaultsInner client, KeyVaultManager manager, GraphRbacManager graphRbacManager) {
        super(key, (Resource)innerObject, (ManagerBase)manager);
        this.client = client;
        this.graphRbacManager = graphRbacManager;
        this.accessPolicies = new ArrayList<AccessPolicyImpl>();
        if (innerObject != null && innerObject.properties() != null && innerObject.properties().accessPolicies() != null) {
            for (AccessPolicyEntry entry : innerObject.properties().accessPolicies()) {
                this.accessPolicies.add(new AccessPolicyImpl(entry, this));
            }
        }
    }

    @Override
    public String vaultUri() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.inner())).properties().vaultUri();
    }

    @Override
    public String tenantId() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        if (((VaultInner)((Object)this.inner())).properties().tenantId() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.inner())).properties().tenantId().toString();
    }

    @Override
    public Sku sku() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.inner())).properties().sku();
    }

    @Override
    public List<AccessPolicy> accessPolicies() {
        AccessPolicy[] array = new AccessPolicy[this.accessPolicies.size()];
        return Arrays.asList(this.accessPolicies.toArray(array));
    }

    @Override
    public boolean enabledForDeployment() {
        if (((VaultInner)((Object)this.inner())).properties() == null || ((VaultInner)((Object)this.inner())).properties().enabledForDeployment() == null) {
            return false;
        }
        return ((VaultInner)((Object)this.inner())).properties().enabledForDeployment();
    }

    @Override
    public boolean enabledForDiskEncryption() {
        if (((VaultInner)((Object)this.inner())).properties() == null || ((VaultInner)((Object)this.inner())).properties().enabledForDiskEncryption() == null) {
            return false;
        }
        return ((VaultInner)((Object)this.inner())).properties().enabledForDiskEncryption();
    }

    @Override
    public boolean enabledForTemplateDeployment() {
        if (((VaultInner)((Object)this.inner())).properties() == null || ((VaultInner)((Object)this.inner())).properties().enabledForTemplateDeployment().booleanValue()) {
            return false;
        }
        return ((VaultInner)((Object)this.inner())).properties().enabledForTemplateDeployment();
    }

    @Override
    public VaultImpl withEmptyAccessPolicy() {
        this.accessPolicies = new ArrayList<AccessPolicyImpl>();
        return this;
    }

    @Override
    public VaultImpl withoutAccessPolicy(String objectId) {
        for (AccessPolicyImpl entry : this.accessPolicies) {
            if (!entry.objectId().equals(objectId)) continue;
            this.accessPolicies.remove(entry);
            break;
        }
        return this;
    }

    @Override
    public VaultImpl withAccessPolicy(AccessPolicy accessPolicy) {
        this.accessPolicies.add((AccessPolicyImpl)accessPolicy);
        return this;
    }

    public AccessPolicyImpl defineAccessPolicy() {
        return new AccessPolicyImpl(new AccessPolicyEntry(), this);
    }

    @Override
    public AccessPolicyImpl updateAccessPolicy(String objectId) {
        for (AccessPolicyImpl entry : this.accessPolicies) {
            if (!entry.objectId().equals(objectId)) continue;
            return entry;
        }
        throw new NoSuchElementException(String.format("Identity %s not found in the access policies.", objectId));
    }

    @Override
    public VaultImpl withDeploymentEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDeployment(true);
        return this;
    }

    @Override
    public VaultImpl withDiskEncryptionEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDiskEncryption(true);
        return this;
    }

    @Override
    public VaultImpl withTemplateDeploymentEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForTemplateDeployment(true);
        return this;
    }

    @Override
    public VaultImpl withDeploymentDisabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDeployment(false);
        return this;
    }

    @Override
    public VaultImpl withDiskEncryptionDisabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDiskEncryption(false);
        return this;
    }

    @Override
    public VaultImpl withTemplateDeploymentDisabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForTemplateDeployment(false);
        return this;
    }

    @Override
    public VaultImpl withSku(SkuName skuName) {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            ((VaultInner)((Object)this.inner())).withProperties(new VaultProperties());
        }
        ((VaultInner)((Object)this.inner())).properties().withSku(new Sku().withName(skuName));
        return this;
    }

    private Observable<List<AccessPolicy>> populateAccessPolicies() {
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (final AccessPolicyImpl accessPolicy : this.accessPolicies) {
            if (accessPolicy.objectId() != null) continue;
            if (accessPolicy.userPrincipalName() != null) {
                observables.add(this.graphRbacManager.users().getByUserPrincipalNameAsync(accessPolicy.userPrincipalName()).subscribeOn(Schedulers.io()).doOnNext((Action1)new Action1<User>(){

                    public void call(User user) {
                        accessPolicy.forObjectId(UUID.fromString(user.objectId()));
                    }
                }));
                continue;
            }
            if (accessPolicy.servicePrincipalName() != null) {
                observables.add(this.graphRbacManager.servicePrincipals().getByServicePrincipalNameAsync(accessPolicy.servicePrincipalName()).subscribeOn(Schedulers.io()).doOnNext((Action1)new Action1<ServicePrincipal>(){

                    public void call(ServicePrincipal sp) {
                        accessPolicy.forObjectId(UUID.fromString(sp.objectId()));
                    }
                }));
                continue;
            }
            throw new IllegalArgumentException("Access policy must specify object ID.");
        }
        if (observables.isEmpty()) {
            return Observable.just(this.accessPolicies());
        }
        return Observable.zip(observables, (FuncN)new FuncN<List<AccessPolicy>>(){

            public List<AccessPolicy> call(Object ... args) {
                return VaultImpl.this.accessPolicies();
            }
        });
    }

    public Observable<Vault> createResourceAsync() {
        return this.populateAccessPolicies().flatMap((Func1)new Func1<Object, Observable<VaultInner>>(){

            public Observable<VaultInner> call(Object o) {
                VaultCreateOrUpdateParametersInner parameters = new VaultCreateOrUpdateParametersInner();
                parameters.withLocation(VaultImpl.this.regionName());
                parameters.withProperties(((VaultInner)((Object)VaultImpl.this.inner())).properties());
                parameters.withTags(((VaultInner)((Object)VaultImpl.this.inner())).getTags());
                parameters.properties().withAccessPolicies(new ArrayList<AccessPolicyEntry>());
                for (AccessPolicy accessPolicy : VaultImpl.this.accessPolicies) {
                    parameters.properties().accessPolicies().add((AccessPolicyEntry)accessPolicy.inner());
                }
                return VaultImpl.this.client.createOrUpdateAsync(VaultImpl.this.resourceGroupName(), VaultImpl.this.name(), parameters);
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public VaultImpl refresh() {
        this.setInner((Object)this.client.get(this.resourceGroupName(), this.name()));
        return this;
    }
}

