/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.SkuName;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.VaultProperties;
import com.microsoft.azure.management.keyvault.Vaults;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.VaultImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.keyvault.implementation.VaultsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import java.util.UUID;
import rx.Observable;

@LangDefinition
class VaultsImpl
extends GroupableResourcesImpl<Vault, VaultImpl, VaultInner, VaultsInner, KeyVaultManager>
implements Vaults {
    private final GraphRbacManager graphRbacManager;
    private final String tenantId;

    VaultsImpl(VaultsInner client, KeyVaultManager keyVaultManager, GraphRbacManager graphRbacManager, String tenantId) {
        super((Object)client, (ManagerBase)keyVaultManager);
        this.graphRbacManager = graphRbacManager;
        this.tenantId = tenantId;
    }

    public PagedList<Vault> list() {
        return this.wrapList(((VaultsInner)this.innerCollection).list());
    }

    public PagedList<Vault> listByGroup(String groupName) {
        return this.wrapList(((VaultsInner)this.innerCollection).listByResourceGroup(groupName));
    }

    public Vault getByGroup(String groupName, String name) {
        return this.wrapModel(((VaultsInner)this.innerCollection).get(groupName, name));
    }

    public Observable<Void> deleteAsync(String groupName, String name) {
        return ((VaultsInner)this.innerCollection).deleteAsync(groupName, name);
    }

    public VaultImpl define(String name) {
        return this.wrapModel(name).withSku(SkuName.STANDARD).withEmptyAccessPolicy();
    }

    protected VaultImpl wrapModel(String name) {
        VaultInner inner = new VaultInner().withProperties(new VaultProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new VaultImpl(name, inner, (VaultsInner)this.innerCollection, (KeyVaultManager)this.myManager, this.graphRbacManager);
    }

    protected VaultImpl wrapModel(VaultInner vaultInner) {
        return new VaultImpl(vaultInner.name(), vaultInner, (VaultsInner)this.innerCollection, (KeyVaultManager)this.myManager, this.graphRbacManager);
    }
}

