/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.PageImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultCreateOrUpdateParametersInner;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public final class VaultsInner {
    private VaultsService service;
    private KeyVaultManagementClientImpl client;

    public VaultsInner(Retrofit retrofit, KeyVaultManagementClientImpl client) {
        this.service = (VaultsService)retrofit.create(VaultsService.class);
        this.client = client;
    }

    public VaultInner createOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParametersInner parameters) {
        return (VaultInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParametersInner parameters, ServiceCallback<VaultInner> serviceCallback) {
        return ServiceCall.create(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    public Observable<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParametersInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map((Func1)new Func1<ServiceResponse<VaultInner>, VaultInner>(){

            public VaultInner call(ServiceResponse<VaultInner> response) {
                return (VaultInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<VaultInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdate(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>(){

            public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VaultInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(201, new TypeToken<VaultInner>(){}.getType()).register(200, new TypeToken<VaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String vaultName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vaultName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, String vaultName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName, vaultName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vaultName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vaultName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vaultName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<Void>(){}.getType()).build(response);
    }

    public VaultInner get(String resourceGroupName, String vaultName) {
        return (VaultInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, vaultName).toBlocking().single()).getBody());
    }

    public ServiceCall<VaultInner> getAsync(String resourceGroupName, String vaultName, ServiceCallback<VaultInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, vaultName), serviceCallback);
    }

    public Observable<VaultInner> getAsync(String resourceGroupName, String vaultName) {
        return this.getWithServiceResponseAsync(resourceGroupName, vaultName).map((Func1)new Func1<ServiceResponse<VaultInner>, VaultInner>(){

            public VaultInner call(ServiceResponse<VaultInner> response) {
                return (VaultInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<VaultInner>> getWithServiceResponseAsync(String resourceGroupName, String vaultName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>(){

            public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VaultInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<VaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.getBody()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<VaultInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceCall.create(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<VaultInner> listByResourceGroup(String resourceGroupName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, top).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.getBody()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<VaultInner>> listByResourceGroupAsync(String resourceGroupName, Integer top, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceCall.create(this.listByResourceGroupSinglePageAsync(resourceGroupName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, top).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, top).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VaultInner>((Page)response.getBody()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<VaultInner>> listAsync(ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        String apiVersion = "2015-11-01";
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), "resourceType eq 'Microsoft.KeyVault/vaults'", top, "2015-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<VaultInner> list(Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(top).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.getBody()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<VaultInner>> listAsync(Integer top, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(top), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listAsync(Integer top) {
        return this.listWithServiceResponseAsync(top).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listWithServiceResponseAsync(Integer top) {
        return this.listSinglePageAsync(top).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listSinglePageAsync(Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        String apiVersion = "2015-11-01";
        return this.service.list(this.client.subscriptionId(), "resourceType eq 'Microsoft.KeyVault/vaults'", top, "2015-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.getBody()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<VaultInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceCall<List<VaultInner>> serviceCall, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceCall.create(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listByResourceGroupNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.getBody()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<VaultInner>> listNextAsync(String nextPageLink, ServiceCall<List<VaultInner>> serviceCall, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VaultsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body VaultCreateOrUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resources")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

