/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.keyvault.AccessPolicy;
import com.microsoft.azure.management.keyvault.Sku;
import com.microsoft.azure.management.keyvault.SkuName;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;

@Fluent(ContainerName="/Microsoft.Azure.Management.Fluent.KeyVault")
public interface Vault
extends GroupableResource<KeyVaultManager, VaultInner>,
Refreshable<Vault>,
Updatable<Update> {
    public String vaultUri();

    public String tenantId();

    public Sku sku();

    public List<AccessPolicy> accessPolicies();

    public boolean enabledForDeployment();

    public boolean enabledForDiskEncryption();

    public boolean enabledForTemplateDeployment();

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<Vault>,
    UpdateStages.WithAccessPolicy,
    UpdateStages.WithConfigurations {
    }

    public static interface UpdateStages {

        public static interface WithConfigurations {
            public Update withDeploymentEnabled();

            public Update withDiskEncryptionEnabled();

            public Update withTemplateDeploymentEnabled();

            public Update withDeploymentDisabled();

            public Update withDiskEncryptionDisabled();

            public Update withTemplateDeploymentDisabled();
        }

        public static interface WithAccessPolicy {
            public Update withoutAccessPolicy(String var1);

            public Update withAccessPolicy(AccessPolicy var1);

            @Method
            public AccessPolicy.UpdateDefinitionStages.Blank<Update> defineAccessPolicy();

            public AccessPolicy.Update updateAccessPolicy(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Vault>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithConfigurations,
        WithAccessPolicy {
        }

        public static interface WithConfigurations {
            public WithCreate withDeploymentEnabled();

            public WithCreate withDiskEncryptionEnabled();

            public WithCreate withTemplateDeploymentEnabled();

            public WithCreate withDeploymentDisabled();

            public WithCreate withDiskEncryptionDisabled();

            public WithCreate withTemplateDeploymentDisabled();
        }

        public static interface WithAccessPolicy {
            public WithCreate withEmptyAccessPolicy();

            public WithCreate withAccessPolicy(AccessPolicy var1);

            @Method
            public AccessPolicy.DefinitionStages.Blank<WithCreate> defineAccessPolicy();
        }

        public static interface WithSku {
            public WithCreate withSku(SkuName var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithAccessPolicy> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithAccessPolicy,
    DefinitionStages.WithCreate {
    }
}

