/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.CheckNameAvailabilityResult;
import com.microsoft.azure.management.keyvault.CreateMode;
import com.microsoft.azure.management.keyvault.DeletedVault;
import com.microsoft.azure.management.keyvault.Sku;
import com.microsoft.azure.management.keyvault.SkuName;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.VaultCreateOrUpdateParameters;
import com.microsoft.azure.management.keyvault.VaultProperties;
import com.microsoft.azure.management.keyvault.Vaults;
import com.microsoft.azure.management.keyvault.implementation.CheckNameAvailabilityResultImpl;
import com.microsoft.azure.management.keyvault.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.keyvault.implementation.DeletedVaultImpl;
import com.microsoft.azure.management.keyvault.implementation.DeletedVaultInner;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.PageImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.keyvault.implementation.VaultsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import java.util.ArrayList;
import java.util.UUID;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class VaultsImpl
extends GroupableResourcesImpl<Vault, VaultImpl, VaultInner, VaultsInner, KeyVaultManager>
implements Vaults {
    private final GraphRbacManager graphRbacManager;
    private final String tenantId;

    VaultsImpl(KeyVaultManager keyVaultManager, GraphRbacManager graphRbacManager, String tenantId) {
        super((Object)((KeyVaultManagementClientImpl)((Object)keyVaultManager.inner())).vaults(), (ManagerBase)keyVaultManager);
        this.graphRbacManager = graphRbacManager;
        this.tenantId = tenantId;
    }

    public PagedList<Vault> listByResourceGroup(String groupName) {
        return this.wrapList(((VaultsInner)this.inner()).listByResourceGroup(groupName));
    }

    public Observable<Vault> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((VaultsInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected Observable<VaultInner> getInnerAsync(String resourceGroupName, String name) {
        return ((VaultsInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((VaultsInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return ((VaultsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    public VaultImpl define(String name) {
        return this.wrapModel(name).withSku(SkuName.STANDARD).withEmptyAccessPolicy();
    }

    protected VaultImpl wrapModel(String name) {
        VaultInner inner = new VaultInner().withProperties(new VaultProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new VaultImpl(name, inner, (KeyVaultManager)this.manager(), this.graphRbacManager);
    }

    protected VaultImpl wrapModel(VaultInner vaultInner) {
        if (vaultInner == null) {
            return null;
        }
        return new VaultImpl(vaultInner.name(), vaultInner, (KeyVaultManager)super.manager(), this.graphRbacManager);
    }

    @Override
    public PagedList<DeletedVault> listDeleted() {
        PagedList<DeletedVaultInner> listDeleted = ((VaultsInner)this.inner()).listDeleted();
        PagedListConverter<DeletedVaultInner, DeletedVault> converter = new PagedListConverter<DeletedVaultInner, DeletedVault>(){

            public Observable<DeletedVault> typeConvertAsync(DeletedVaultInner inner) {
                DeletedVaultImpl deletedVault = new DeletedVaultImpl(inner);
                return Observable.just((Object)deletedVault);
            }
        };
        return converter.convert(listDeleted);
    }

    @Override
    public DeletedVault getDeleted(String vaultName, String location) {
        DeletedVaultInner deletedVault = ((VaultsInner)this.inner()).getDeleted(vaultName, location);
        if (deletedVault == null) {
            return null;
        }
        return new DeletedVaultImpl(deletedVault);
    }

    @Override
    public void purgeDeleted(String vaultName, String location) {
        ((VaultsInner)this.inner()).purgeDeleted(vaultName, location);
    }

    @Override
    public Observable<DeletedVault> getDeletedAsync(String vaultName, String location) {
        VaultsInner client = (VaultsInner)this.inner();
        return client.getDeletedAsync(vaultName, location).map((Func1)new Func1<DeletedVaultInner, DeletedVault>(){

            public DeletedVault call(DeletedVaultInner inner) {
                return new DeletedVaultImpl(inner);
            }
        });
    }

    @Override
    public Completable purgeDeletedAsync(String vaultName, String location) {
        return ((VaultsInner)this.inner()).purgeDeletedAsync(vaultName, location).toCompletable();
    }

    private Observable<DeletedVault> convertPageDeletedVaultToDeletedVaultAsync(Observable<Page<DeletedVault>> page) {
        return page.flatMap((Func1)new Func1<Page<DeletedVault>, Observable<DeletedVault>>(){

            public Observable<DeletedVault> call(Page<DeletedVault> inner) {
                return Observable.from((Iterable)inner.items());
            }
        });
    }

    @Override
    public Observable<DeletedVault> listDeletedAsync() {
        VaultsInner client = (VaultsInner)this.inner();
        Observable page = client.listDeletedAsync().map((Func1)new Func1<Page<DeletedVaultInner>, Page<DeletedVault>>(){

            public Page<DeletedVault> call(Page<DeletedVaultInner> inner) {
                return VaultsImpl.this.convertPageDeletedVaultInner((Page<DeletedVaultInner>)inner);
            }
        });
        return this.convertPageDeletedVaultToDeletedVaultAsync((Observable<Page<DeletedVault>>)page);
    }

    private Page<DeletedVault> convertPageDeletedVaultInner(Page<DeletedVaultInner> inner) {
        ArrayList<DeletedVaultImpl> items = new ArrayList<DeletedVaultImpl>();
        for (DeletedVaultInner item : inner.items()) {
            items.add(new DeletedVaultImpl(item));
        }
        PageImpl<DeletedVault> deletedVaultPage = new PageImpl<DeletedVault>();
        deletedVaultPage.setItems(items);
        return deletedVaultPage;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((VaultsInner)this.inner()).checkNameAvailability(name));
    }

    @Override
    public Observable<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        VaultsInner client = (VaultsInner)this.inner();
        return client.checkNameAvailabilityAsync(name).map((Func1)new Func1<CheckNameAvailabilityResultInner, CheckNameAvailabilityResult>(){

            public CheckNameAvailabilityResult call(CheckNameAvailabilityResultInner inner) {
                return new CheckNameAvailabilityResultImpl(inner);
            }
        });
    }

    @Override
    public Vault recoverSoftDeletedVault(String resourceGroupName, String vaultName, String location) {
        return (Vault)this.recoverSoftDeletedVaultAsync(resourceGroupName, vaultName, location).toBlocking().last();
    }

    @Override
    public Observable<Vault> recoverSoftDeletedVaultAsync(final String resourceGroupName, final String vaultName, String location) {
        final KeyVaultManager manager = (KeyVaultManager)this.manager();
        return this.getDeletedAsync(vaultName, location).flatMap((Func1)new Func1<DeletedVault, Observable<Vault>>(){

            public Observable<Vault> call(DeletedVault deletedVault) {
                VaultCreateOrUpdateParameters parameters = new VaultCreateOrUpdateParameters();
                parameters.withLocation(deletedVault.location());
                parameters.withTags(((DeletedVaultInner)deletedVault.inner()).properties().tags());
                parameters.withProperties(new VaultProperties().withCreateMode(CreateMode.RECOVER).withSku(new Sku().withName(SkuName.STANDARD)).withTenantId(UUID.fromString(VaultsImpl.this.tenantId)));
                return ((VaultsInner)VaultsImpl.this.inner()).createOrUpdateAsync(resourceGroupName, vaultName, parameters).map((Func1)new Func1<VaultInner, Vault>(){

                    public Vault call(VaultInner inner) {
                        return new VaultImpl(inner.id(), inner, manager, VaultsImpl.this.graphRbacManager);
                    }
                });
            }
        });
    }
}

