/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.keyvault;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for SecretPermissions.
 */
public final class SecretPermissions {
    /** Static value all for SecretPermissions. */
    public static final SecretPermissions ALL = new SecretPermissions("all");

    /** Static value get for SecretPermissions. */
    public static final SecretPermissions GET = new SecretPermissions("get");

    /** Static value list for SecretPermissions. */
    public static final SecretPermissions LIST = new SecretPermissions("list");

    /** Static value set for SecretPermissions. */
    public static final SecretPermissions SET = new SecretPermissions("set");

    /** Static value delete for SecretPermissions. */
    public static final SecretPermissions DELETE = new SecretPermissions("delete");

    private String value;

    /**
     * Creates a custom value for SecretPermissions.
     * @param value the custom value
     */
    public SecretPermissions(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SecretPermissions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SecretPermissions rhs = (SecretPermissions) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
