/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.SkuName;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.VaultProperties;
import com.microsoft.azure.management.keyvault.Vaults;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.VaultImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.keyvault.implementation.VaultsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import java.util.UUID;
import rx.Completable;
import rx.Observable;

@LangDefinition
class VaultsImpl
extends GroupableResourcesImpl<Vault, VaultImpl, VaultInner, VaultsInner, KeyVaultManager>
implements Vaults {
    private final GraphRbacManager graphRbacManager;
    private final String tenantId;

    VaultsImpl(KeyVaultManager keyVaultManager, GraphRbacManager graphRbacManager, String tenantId) {
        super((Object)((KeyVaultManagementClientImpl)((Object)keyVaultManager.inner())).vaults(), (ManagerBase)keyVaultManager);
        this.graphRbacManager = graphRbacManager;
        this.tenantId = tenantId;
    }

    public PagedList<Vault> listByResourceGroup(String groupName) {
        return this.wrapList(((VaultsInner)this.inner()).listByResourceGroup(groupName));
    }

    protected Observable<VaultInner> getInnerAsync(String resourceGroupName, String name) {
        return ((VaultsInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((VaultsInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return ((VaultsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    public VaultImpl define(String name) {
        return this.wrapModel(name).withSku(SkuName.STANDARD).withEmptyAccessPolicy();
    }

    protected VaultImpl wrapModel(String name) {
        VaultInner inner = new VaultInner().withProperties(new VaultProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new VaultImpl(name, inner, (KeyVaultManager)this.manager(), this.graphRbacManager);
    }

    protected VaultImpl wrapModel(VaultInner vaultInner) {
        if (vaultInner == null) {
            return null;
        }
        return new VaultImpl(vaultInner.name(), vaultInner, (KeyVaultManager)super.manager(), this.graphRbacManager);
    }

    public Observable<Vault> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((VaultsInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }
}

