/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.keyvault.AccessPolicyUpdateKind;
import com.microsoft.azure.management.keyvault.VaultAccessPolicyProperties;
import com.microsoft.azure.management.keyvault.VaultCheckNameAvailabilityParameters;
import com.microsoft.azure.management.keyvault.VaultCreateOrUpdateParameters;
import com.microsoft.azure.management.keyvault.VaultPatchParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Vaults.
 */
public class VaultsInner implements InnerSupportsGet<VaultInner>, InnerSupportsDelete<Void> {
    /** The Retrofit service to perform REST calls. */
    private VaultsService service;
    /** The service client containing this operation class. */
    private KeyVaultManagementClientImpl client;

    /**
     * Initializes an instance of VaultsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VaultsInner(Retrofit retrofit, KeyVaultManagementClientImpl client) {
        this.service = retrofit.create(VaultsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Vaults to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VaultsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vaultName") String vaultName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Body VaultCreateOrUpdateParameters parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vaultName") String vaultName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Body VaultCreateOrUpdateParameters parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("vaultName") String vaultName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Body VaultPatchParameters parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("vaultName") String vaultName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("vaultName") String vaultName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults updateAccessPolicy" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/accessPolicies/{operationKind}")
        Observable<Response<ResponseBody>> updateAccessPolicy(@Path("resourceGroupName") String resourceGroupName, @Path("vaultName") String vaultName, @Path("operationKind") AccessPolicyUpdateKind operationKind, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body VaultAccessPolicyParametersInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listBySubscription" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/vaults")
        Observable<Response<ResponseBody>> listBySubscription(@Path("subscriptionId") String subscriptionId, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listDeleted" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/deletedVaults")
        Observable<Response<ResponseBody>> listDeleted(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults getDeleted" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}")
        Observable<Response<ResponseBody>> getDeleted(@Path("vaultName") String vaultName, @Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults purgeDeleted" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge")
        Observable<Response<ResponseBody>> purgeDeleted(@Path("vaultName") String vaultName, @Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults beginPurgeDeleted" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge")
        Observable<Response<ResponseBody>> beginPurgeDeleted(@Path("vaultName") String vaultName, @Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults list" })
        @GET("subscriptions/{subscriptionId}/resources")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults checkNameAvailability" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/checkNameAvailability")
        Observable<Response<ResponseBody>> checkNameAvailability(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body VaultCheckNameAvailabilityParameters vaultName, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listBySubscriptionNext" })
        @GET
        Observable<Response<ResponseBody>> listBySubscriptionNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listDeletedNext" })
        @GET
        Observable<Response<ResponseBody>> listDeletedNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VaultInner object if successful.
     */
    public VaultInner createOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().last().body();
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, final ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map(new Func1<ServiceResponse<VaultInner>, VaultInner>() {
            @Override
            public VaultInner call(ServiceResponse<VaultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VaultInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VaultInner>() { }.getType());
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VaultInner object if successful.
     */
    public VaultInner beginCreateOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, final ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultInner object
     */
    public Observable<VaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map(new Func1<ServiceResponse<VaultInner>, VaultInner>() {
            @Override
            public VaultInner call(ServiceResponse<VaultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to create or update the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultInner object
     */
    public Observable<ServiceResponse<VaultInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdate(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>() {
                @Override
                public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VaultInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VaultInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VaultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VaultInner>() { }.getType())
                .register(201, new TypeToken<VaultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to patch the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VaultInner object if successful.
     */
    public VaultInner update(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().single().body();
    }

    /**
     * Update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to patch the vault
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VaultInner> updateAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters, final ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    /**
     * Update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to patch the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultInner object
     */
    public Observable<VaultInner> updateAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map(new Func1<ServiceResponse<VaultInner>, VaultInner>() {
            @Override
            public VaultInner call(ServiceResponse<VaultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the server belongs.
     * @param vaultName Name of the vault
     * @param parameters Parameters to patch the vault
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultInner object
     */
    public Observable<ServiceResponse<VaultInner>> updateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>() {
                @Override
                public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VaultInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VaultInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VaultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VaultInner>() { }.getType())
                .register(201, new TypeToken<VaultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String vaultName) {
        deleteWithServiceResponseAsync(resourceGroupName, vaultName).toBlocking().single().body();
    }

    /**
     * Deletes the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault to delete
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vaultName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, vaultName), serviceCallback);
    }

    /**
     * Deletes the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String vaultName) {
        return deleteWithServiceResponseAsync(resourceGroupName, vaultName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault to delete
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vaultName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VaultInner object if successful.
     */
    public VaultInner getByResourceGroup(String resourceGroupName, String vaultName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, vaultName).toBlocking().single().body();
    }

    /**
     * Gets the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VaultInner> getByResourceGroupAsync(String resourceGroupName, String vaultName, final ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, vaultName), serviceCallback);
    }

    /**
     * Gets the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultInner object
     */
    public Observable<VaultInner> getByResourceGroupAsync(String resourceGroupName, String vaultName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, vaultName).map(new Func1<ServiceResponse<VaultInner>, VaultInner>() {
            @Override
            public VaultInner call(ServiceResponse<VaultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Azure key vault.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultInner object
     */
    public Observable<ServiceResponse<VaultInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vaultName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>() {
                @Override
                public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VaultInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VaultInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VaultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VaultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update access policies in a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName Name of the vault
     * @param operationKind Name of the operation. Possible values include: 'add', 'replace', 'remove'
     * @param properties Properties of the access policy
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VaultAccessPolicyParametersInner object if successful.
     */
    public VaultAccessPolicyParametersInner updateAccessPolicy(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        return updateAccessPolicyWithServiceResponseAsync(resourceGroupName, vaultName, operationKind, properties).toBlocking().single().body();
    }

    /**
     * Update access policies in a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName Name of the vault
     * @param operationKind Name of the operation. Possible values include: 'add', 'replace', 'remove'
     * @param properties Properties of the access policy
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VaultAccessPolicyParametersInner> updateAccessPolicyAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties, final ServiceCallback<VaultAccessPolicyParametersInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateAccessPolicyWithServiceResponseAsync(resourceGroupName, vaultName, operationKind, properties), serviceCallback);
    }

    /**
     * Update access policies in a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName Name of the vault
     * @param operationKind Name of the operation. Possible values include: 'add', 'replace', 'remove'
     * @param properties Properties of the access policy
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultAccessPolicyParametersInner object
     */
    public Observable<VaultAccessPolicyParametersInner> updateAccessPolicyAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        return updateAccessPolicyWithServiceResponseAsync(resourceGroupName, vaultName, operationKind, properties).map(new Func1<ServiceResponse<VaultAccessPolicyParametersInner>, VaultAccessPolicyParametersInner>() {
            @Override
            public VaultAccessPolicyParametersInner call(ServiceResponse<VaultAccessPolicyParametersInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update access policies in a key vault in the specified subscription.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName Name of the vault
     * @param operationKind Name of the operation. Possible values include: 'add', 'replace', 'remove'
     * @param properties Properties of the access policy
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VaultAccessPolicyParametersInner object
     */
    public Observable<ServiceResponse<VaultAccessPolicyParametersInner>> updateAccessPolicyWithServiceResponseAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (operationKind == null) {
            throw new IllegalArgumentException("Parameter operationKind is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate(properties);
        VaultAccessPolicyParametersInner parameters = new VaultAccessPolicyParametersInner();
        parameters.withProperties(properties);
        return service.updateAccessPolicy(resourceGroupName, vaultName, operationKind, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultAccessPolicyParametersInner>>>() {
                @Override
                public Observable<ServiceResponse<VaultAccessPolicyParametersInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VaultAccessPolicyParametersInner> clientResponse = updateAccessPolicyDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VaultAccessPolicyParametersInner> updateAccessPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VaultAccessPolicyParametersInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VaultAccessPolicyParametersInner>() { }.getType())
                .register(201, new TypeToken<VaultAccessPolicyParametersInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VaultInner&gt; object if successful.
     */
    public PagedList<VaultInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VaultInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VaultInner>(response.body()) {
            @Override
            public Page<VaultInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VaultInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<Page<VaultInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>() {
                @Override
                public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer top = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VaultInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VaultInner&gt; object if successful.
     */
    public PagedList<VaultInner> listByResourceGroup(final String resourceGroupName, final Integer top) {
        ServiceResponse<Page<VaultInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, top).toBlocking().single();
        return new PagedList<VaultInner>(response.body()) {
            @Override
            public Page<VaultInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param top Maximum number of results to return.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VaultInner>> listByResourceGroupAsync(final String resourceGroupName, final Integer top, final ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, top),
            new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<Page<VaultInner>> listByResourceGroupAsync(final String resourceGroupName, final Integer top) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, top)
            .map(new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>() {
                @Override
                public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final Integer top) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, top)
            .concatMap(new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
    ServiceResponse<PageImpl<VaultInner>> * @param resourceGroupName The name of the Resource Group to which the vault belongs.
    ServiceResponse<PageImpl<VaultInner>> * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VaultInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VaultInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VaultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VaultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VaultInner&gt; object if successful.
     */
    public PagedList<VaultInner> listBySubscription() {
        ServiceResponse<Page<VaultInner>> response = listBySubscriptionSinglePageAsync().toBlocking().single();
        return new PagedList<VaultInner>(response.body()) {
            @Override
            public Page<VaultInner> nextPage(String nextPageLink) {
                return listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VaultInner>> listBySubscriptionAsync(final ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySubscriptionSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                    return listBySubscriptionNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<Page<VaultInner>> listBySubscriptionAsync() {
        return listBySubscriptionWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>() {
                @Override
                public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionWithServiceResponseAsync() {
        return listBySubscriptionSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySubscriptionNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer top = null;
        return service.listBySubscription(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VaultInner>> result = listBySubscriptionDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VaultInner&gt; object if successful.
     */
    public PagedList<VaultInner> listBySubscription(final Integer top) {
        ServiceResponse<Page<VaultInner>> response = listBySubscriptionSinglePageAsync(top).toBlocking().single();
        return new PagedList<VaultInner>(response.body()) {
            @Override
            public Page<VaultInner> nextPage(String nextPageLink) {
                return listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VaultInner>> listBySubscriptionAsync(final Integer top, final ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySubscriptionSinglePageAsync(top),
            new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                    return listBySubscriptionNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<Page<VaultInner>> listBySubscriptionAsync(final Integer top) {
        return listBySubscriptionWithServiceResponseAsync(top)
            .map(new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>() {
                @Override
                public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionWithServiceResponseAsync(final Integer top) {
        return listBySubscriptionSinglePageAsync(top)
            .concatMap(new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySubscriptionNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
    ServiceResponse<PageImpl<VaultInner>> * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionSinglePageAsync(final Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listBySubscription(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VaultInner>> result = listBySubscriptionDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VaultInner>> listBySubscriptionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VaultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VaultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedVaultInner&gt; object if successful.
     */
    public PagedList<DeletedVaultInner> listDeleted() {
        ServiceResponse<Page<DeletedVaultInner>> response = listDeletedSinglePageAsync().toBlocking().single();
        return new PagedList<DeletedVaultInner>(response.body()) {
            @Override
            public Page<DeletedVaultInner> nextPage(String nextPageLink) {
                return listDeletedNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeletedVaultInner>> listDeletedAsync(final ListOperationCallback<DeletedVaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDeletedSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DeletedVaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(String nextPageLink) {
                    return listDeletedNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedVaultInner&gt; object
     */
    public Observable<Page<DeletedVaultInner>> listDeletedAsync() {
        return listDeletedWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DeletedVaultInner>>, Page<DeletedVaultInner>>() {
                @Override
                public Page<DeletedVaultInner> call(ServiceResponse<Page<DeletedVaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedVaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedWithServiceResponseAsync() {
        return listDeletedSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DeletedVaultInner>>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(ServiceResponse<Page<DeletedVaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDeletedNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeletedVaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listDeleted(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeletedVaultInner>> result = listDeletedDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeletedVaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeletedVaultInner>> listDeletedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeletedVaultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeletedVaultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the deleted Azure key vault.
     *
     * @param vaultName The name of the vault.
     * @param location The location of the deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedVaultInner object if successful.
     */
    public DeletedVaultInner getDeleted(String vaultName, String location) {
        return getDeletedWithServiceResponseAsync(vaultName, location).toBlocking().single().body();
    }

    /**
     * Gets the deleted Azure key vault.
     *
     * @param vaultName The name of the vault.
     * @param location The location of the deleted vault.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeletedVaultInner> getDeletedAsync(String vaultName, String location, final ServiceCallback<DeletedVaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDeletedWithServiceResponseAsync(vaultName, location), serviceCallback);
    }

    /**
     * Gets the deleted Azure key vault.
     *
     * @param vaultName The name of the vault.
     * @param location The location of the deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedVaultInner object
     */
    public Observable<DeletedVaultInner> getDeletedAsync(String vaultName, String location) {
        return getDeletedWithServiceResponseAsync(vaultName, location).map(new Func1<ServiceResponse<DeletedVaultInner>, DeletedVaultInner>() {
            @Override
            public DeletedVaultInner call(ServiceResponse<DeletedVaultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the deleted Azure key vault.
     *
     * @param vaultName The name of the vault.
     * @param location The location of the deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedVaultInner object
     */
    public Observable<ServiceResponse<DeletedVaultInner>> getDeletedWithServiceResponseAsync(String vaultName, String location) {
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getDeleted(vaultName, location, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedVaultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeletedVaultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeletedVaultInner> clientResponse = getDeletedDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeletedVaultInner> getDeletedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeletedVaultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeletedVaultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void purgeDeleted(String vaultName, String location) {
        purgeDeletedWithServiceResponseAsync(vaultName, location).toBlocking().last().body();
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> purgeDeletedAsync(String vaultName, String location, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(purgeDeletedWithServiceResponseAsync(vaultName, location), serviceCallback);
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> purgeDeletedAsync(String vaultName, String location) {
        return purgeDeletedWithServiceResponseAsync(vaultName, location).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> purgeDeletedWithServiceResponseAsync(String vaultName, String location) {
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.purgeDeleted(vaultName, location, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginPurgeDeleted(String vaultName, String location) {
        beginPurgeDeletedWithServiceResponseAsync(vaultName, location).toBlocking().single().body();
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginPurgeDeletedAsync(String vaultName, String location, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginPurgeDeletedWithServiceResponseAsync(vaultName, location), serviceCallback);
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginPurgeDeletedAsync(String vaultName, String location) {
        return beginPurgeDeletedWithServiceResponseAsync(vaultName, location).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Permanently deletes the specified vault. aka Purges the deleted Azure key vault.
     *
     * @param vaultName The name of the soft-deleted vault.
     * @param location The location of the soft-deleted vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginPurgeDeletedWithServiceResponseAsync(String vaultName, String location) {
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginPurgeDeleted(vaultName, location, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginPurgeDeletedDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginPurgeDeletedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Resource&gt; object if successful.
     */
    public PagedList<Resource> list() {
        ServiceResponse<Page<Resource>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<Resource>(response.body()) {
            @Override
            public Page<Resource> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Resource>> listAsync(final ListOperationCallback<Resource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Resource&gt; object
     */
    public Observable<Page<Resource>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<Resource>>, Page<Resource>>() {
                @Override
                public Page<Resource> call(ServiceResponse<Page<Resource>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Resource&gt; object
     */
    public Observable<ServiceResponse<Page<Resource>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<Resource>>, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(ServiceResponse<Page<Resource>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Resource&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Resource>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        final String apiVersion = "2015-11-01";
        final Integer top = null;
        return service.list(this.client.subscriptionId(), filter, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Resource>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Resource>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Resource&gt; object if successful.
     */
    public PagedList<Resource> list(final Integer top) {
        ServiceResponse<Page<Resource>> response = listSinglePageAsync(top).toBlocking().single();
        return new PagedList<Resource>(response.body()) {
            @Override
            public Page<Resource> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Resource>> listAsync(final Integer top, final ListOperationCallback<Resource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(top),
            new Func1<String, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Resource&gt; object
     */
    public Observable<Page<Resource>> listAsync(final Integer top) {
        return listWithServiceResponseAsync(top)
            .map(new Func1<ServiceResponse<Page<Resource>>, Page<Resource>>() {
                @Override
                public Page<Resource> call(ServiceResponse<Page<Resource>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Resource&gt; object
     */
    public Observable<ServiceResponse<Page<Resource>>> listWithServiceResponseAsync(final Integer top) {
        return listSinglePageAsync(top)
            .concatMap(new Func1<ServiceResponse<Page<Resource>>, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(ServiceResponse<Page<Resource>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
    ServiceResponse<PageImpl<Resource>> * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Resource&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Resource>>> listSinglePageAsync(final Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        final String apiVersion = "2015-11-01";
        return service.list(this.client.subscriptionId(), filter, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Resource>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Resource>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<Resource>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<Resource>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<Resource>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks that the vault name is valid and is not already in use.
     *
     * @param name The vault name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CheckNameAvailabilityResultInner object if successful.
     */
    public CheckNameAvailabilityResultInner checkNameAvailability(String name) {
        return checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single().body();
    }

    /**
     * Checks that the vault name is valid and is not already in use.
     *
     * @param name The vault name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name, final ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    /**
     * Checks that the vault name is valid and is not already in use.
     *
     * @param name The vault name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CheckNameAvailabilityResultInner object
     */
    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name) {
        return checkNameAvailabilityWithServiceResponseAsync(name).map(new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>() {
            @Override
            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks that the vault name is valid and is not already in use.
     *
     * @param name The vault name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CheckNameAvailabilityResultInner object
     */
    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        VaultCheckNameAvailabilityParameters vaultName = new VaultCheckNameAvailabilityParameters();
        vaultName.withName(name);
        return service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), vaultName, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>() {
                @Override
                public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CheckNameAvailabilityResultInner> clientResponse = checkNameAvailabilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CheckNameAvailabilityResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CheckNameAvailabilityResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VaultInner&gt; object if successful.
     */
    public PagedList<VaultInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VaultInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VaultInner>(response.body()) {
            @Override
            public Page<VaultInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VaultInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VaultInner>> serviceFuture, final ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<Page<VaultInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>() {
                @Override
                public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription and within the specified resource group.
     *
    ServiceResponse<PageImpl<VaultInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VaultInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VaultInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VaultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VaultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VaultInner&gt; object if successful.
     */
    public PagedList<VaultInner> listBySubscriptionNext(final String nextPageLink) {
        ServiceResponse<Page<VaultInner>> response = listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VaultInner>(response.body()) {
            @Override
            public Page<VaultInner> nextPage(String nextPageLink) {
                return listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VaultInner>> listBySubscriptionNextAsync(final String nextPageLink, final ServiceFuture<List<VaultInner>> serviceFuture, final ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySubscriptionNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                    return listBySubscriptionNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<Page<VaultInner>> listBySubscriptionNextAsync(final String nextPageLink) {
        return listBySubscriptionNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>() {
                @Override
                public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionNextWithServiceResponseAsync(final String nextPageLink) {
        return listBySubscriptionNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySubscriptionNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
    ServiceResponse<PageImpl<VaultInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBySubscriptionNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VaultInner>> result = listBySubscriptionNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VaultInner>> listBySubscriptionNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VaultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VaultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedVaultInner&gt; object if successful.
     */
    public PagedList<DeletedVaultInner> listDeletedNext(final String nextPageLink) {
        ServiceResponse<Page<DeletedVaultInner>> response = listDeletedNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedVaultInner>(response.body()) {
            @Override
            public Page<DeletedVaultInner> nextPage(String nextPageLink) {
                return listDeletedNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeletedVaultInner>> listDeletedNextAsync(final String nextPageLink, final ServiceFuture<List<DeletedVaultInner>> serviceFuture, final ListOperationCallback<DeletedVaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDeletedNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DeletedVaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(String nextPageLink) {
                    return listDeletedNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedVaultInner&gt; object
     */
    public Observable<Page<DeletedVaultInner>> listDeletedNextAsync(final String nextPageLink) {
        return listDeletedNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DeletedVaultInner>>, Page<DeletedVaultInner>>() {
                @Override
                public Page<DeletedVaultInner> call(ServiceResponse<Page<DeletedVaultInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedVaultInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedNextWithServiceResponseAsync(final String nextPageLink) {
        return listDeletedNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DeletedVaultInner>>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(ServiceResponse<Page<DeletedVaultInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDeletedNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets information about the deleted vaults in a subscription.
     *
    ServiceResponse<PageImpl<DeletedVaultInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeletedVaultInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listDeletedNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeletedVaultInner>> result = listDeletedNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeletedVaultInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeletedVaultInner>> listDeletedNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeletedVaultInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeletedVaultInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;Resource&gt; object if successful.
     */
    public PagedList<Resource> listNext(final String nextPageLink) {
        ServiceResponse<Page<Resource>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Resource>(response.body()) {
            @Override
            public Page<Resource> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<Resource>> listNextAsync(final String nextPageLink, final ServiceFuture<List<Resource>> serviceFuture, final ListOperationCallback<Resource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Resource&gt; object
     */
    public Observable<Page<Resource>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<Resource>>, Page<Resource>>() {
                @Override
                public Page<Resource> call(ServiceResponse<Page<Resource>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;Resource&gt; object
     */
    public Observable<ServiceResponse<Page<Resource>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<Resource>>, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(ServiceResponse<Page<Resource>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The List operation gets information about the vaults associated with the subscription.
     *
    ServiceResponse<PageImpl<Resource>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;Resource&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<Resource>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Resource>>>>() {
                @Override
                public Observable<ServiceResponse<Page<Resource>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<Resource>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<Resource>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<Resource>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<Resource>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<Resource>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
