/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.keyvault.AccessPolicyUpdateKind;
import com.microsoft.azure.management.keyvault.VaultAccessPolicyProperties;
import com.microsoft.azure.management.keyvault.VaultCheckNameAvailabilityParameters;
import com.microsoft.azure.management.keyvault.VaultCreateOrUpdateParameters;
import com.microsoft.azure.management.keyvault.VaultPatchParameters;
import com.microsoft.azure.management.keyvault.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.keyvault.implementation.DeletedVaultInner;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.PageImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultAccessPolicyParametersInner;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VaultsInner
implements InnerSupportsGet<VaultInner>,
InnerSupportsDelete<Void> {
    private VaultsService service;
    private KeyVaultManagementClientImpl client;

    public VaultsInner(Retrofit retrofit, KeyVaultManagementClientImpl client) {
        this.service = (VaultsService)retrofit.create(VaultsService.class);
        this.client = client;
    }

    public VaultInner createOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return (VaultInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    public Observable<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map((Func1)new Func1<ServiceResponse<VaultInner>, VaultInner>(){

            public VaultInner call(ServiceResponse<VaultInner> response) {
                return (VaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VaultInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VaultInner>(){}.getType());
    }

    public VaultInner beginCreateOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return (VaultInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    public Observable<VaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map((Func1)new Func1<ServiceResponse<VaultInner>, VaultInner>(){

            public VaultInner call(ServiceResponse<VaultInner> response) {
                return (VaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VaultInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreateOrUpdate(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>(){

            public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VaultInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VaultInner>(){}.getType()).register(201, new TypeToken<VaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VaultInner update(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        return (VaultInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VaultInner> updateAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters, ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, vaultName, parameters), serviceCallback);
    }

    public Observable<VaultInner> updateAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, vaultName, parameters).map((Func1)new Func1<ServiceResponse<VaultInner>, VaultInner>(){

            public VaultInner call(ServiceResponse<VaultInner> response) {
                return (VaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VaultInner>> updateWithServiceResponseAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>(){

            public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VaultInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VaultInner>(){}.getType()).register(201, new TypeToken<VaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String vaultName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vaultName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vaultName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vaultName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vaultName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vaultName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vaultName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VaultInner getByResourceGroup(String resourceGroupName, String vaultName) {
        return (VaultInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vaultName).toBlocking().single()).body());
    }

    public ServiceFuture<VaultInner> getByResourceGroupAsync(String resourceGroupName, String vaultName, ServiceCallback<VaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vaultName), serviceCallback);
    }

    public Observable<VaultInner> getByResourceGroupAsync(String resourceGroupName, String vaultName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vaultName).map((Func1)new Func1<ServiceResponse<VaultInner>, VaultInner>(){

            public VaultInner call(ServiceResponse<VaultInner> response) {
                return (VaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VaultInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vaultName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, vaultName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultInner>>>(){

            public Observable<ServiceResponse<VaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VaultInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VaultAccessPolicyParametersInner updateAccessPolicy(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        return (VaultAccessPolicyParametersInner)((ServiceResponse)this.updateAccessPolicyWithServiceResponseAsync(resourceGroupName, vaultName, operationKind, properties).toBlocking().single()).body();
    }

    public ServiceFuture<VaultAccessPolicyParametersInner> updateAccessPolicyAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties, ServiceCallback<VaultAccessPolicyParametersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateAccessPolicyWithServiceResponseAsync(resourceGroupName, vaultName, operationKind, properties), serviceCallback);
    }

    public Observable<VaultAccessPolicyParametersInner> updateAccessPolicyAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        return this.updateAccessPolicyWithServiceResponseAsync(resourceGroupName, vaultName, operationKind, properties).map((Func1)new Func1<ServiceResponse<VaultAccessPolicyParametersInner>, VaultAccessPolicyParametersInner>(){

            public VaultAccessPolicyParametersInner call(ServiceResponse<VaultAccessPolicyParametersInner> response) {
                return (VaultAccessPolicyParametersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VaultAccessPolicyParametersInner>> updateAccessPolicyWithServiceResponseAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (operationKind == null) {
            throw new IllegalArgumentException("Parameter operationKind is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate((Object)properties);
        VaultAccessPolicyParametersInner parameters = new VaultAccessPolicyParametersInner();
        parameters.withProperties(properties);
        return this.service.updateAccessPolicy(resourceGroupName, vaultName, operationKind, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VaultAccessPolicyParametersInner>>>(){

            public Observable<ServiceResponse<VaultAccessPolicyParametersInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.updateAccessPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VaultAccessPolicyParametersInner> updateAccessPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VaultAccessPolicyParametersInner>(){}.getType()).register(201, new TypeToken<VaultAccessPolicyParametersInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.body()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VaultInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<VaultInner> listByResourceGroup(String resourceGroupName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, top).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.body()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VaultInner>> listByResourceGroupAsync(String resourceGroupName, Integer top, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, top).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, top).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listBySubscription() {
        ServiceResponse response = (ServiceResponse)this.listBySubscriptionSinglePageAsync().toBlocking().single();
        return new PagedList<VaultInner>((Page)response.body()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VaultInner>> listBySubscriptionAsync(ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySubscriptionSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listBySubscriptionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listBySubscriptionAsync() {
        return this.listBySubscriptionWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionWithServiceResponseAsync() {
        return this.listBySubscriptionSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listBySubscriptionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listBySubscription(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listBySubscriptionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<VaultInner> listBySubscription(Integer top) {
        ServiceResponse response = (ServiceResponse)this.listBySubscriptionSinglePageAsync(top).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.body()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VaultInner>> listBySubscriptionAsync(Integer top, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySubscriptionSinglePageAsync(top), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listBySubscriptionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listBySubscriptionAsync(Integer top) {
        return this.listBySubscriptionWithServiceResponseAsync(top).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionWithServiceResponseAsync(Integer top) {
        return this.listBySubscriptionSinglePageAsync(top).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listBySubscriptionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionSinglePageAsync(Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listBySubscription(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listBySubscriptionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listBySubscriptionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeletedVaultInner> listDeleted() {
        ServiceResponse response = (ServiceResponse)this.listDeletedSinglePageAsync().toBlocking().single();
        return new PagedList<DeletedVaultInner>((Page)response.body()){

            public Page<DeletedVaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listDeletedNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeletedVaultInner>> listDeletedAsync(ListOperationCallback<DeletedVaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listDeletedSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedVaultInner>>>>(){

            public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listDeletedNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeletedVaultInner>> listDeletedAsync() {
        return this.listDeletedWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DeletedVaultInner>>, Page<DeletedVaultInner>>(){

            public Page<DeletedVaultInner> call(ServiceResponse<Page<DeletedVaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedWithServiceResponseAsync() {
        return this.listDeletedSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DeletedVaultInner>>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>(){

            public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(ServiceResponse<Page<DeletedVaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listDeletedNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listDeleted(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>(){

            public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listDeletedDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedVaultInner>> listDeletedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedVaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeletedVaultInner getDeleted(String vaultName, String location) {
        return (DeletedVaultInner)((ServiceResponse)this.getDeletedWithServiceResponseAsync(vaultName, location).toBlocking().single()).body();
    }

    public ServiceFuture<DeletedVaultInner> getDeletedAsync(String vaultName, String location, ServiceCallback<DeletedVaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDeletedWithServiceResponseAsync(vaultName, location), serviceCallback);
    }

    public Observable<DeletedVaultInner> getDeletedAsync(String vaultName, String location) {
        return this.getDeletedWithServiceResponseAsync(vaultName, location).map((Func1)new Func1<ServiceResponse<DeletedVaultInner>, DeletedVaultInner>(){

            public DeletedVaultInner call(ServiceResponse<DeletedVaultInner> response) {
                return (DeletedVaultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeletedVaultInner>> getDeletedWithServiceResponseAsync(String vaultName, String location) {
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getDeleted(vaultName, location, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedVaultInner>>>(){

            public Observable<ServiceResponse<DeletedVaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.getDeletedDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedVaultInner> getDeletedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeletedVaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void purgeDeleted(String vaultName, String location) {
        ((ServiceResponse)this.purgeDeletedWithServiceResponseAsync(vaultName, location).toBlocking().last()).body();
    }

    public ServiceFuture<Void> purgeDeletedAsync(String vaultName, String location, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeDeletedWithServiceResponseAsync(vaultName, location), serviceCallback);
    }

    public Observable<Void> purgeDeletedAsync(String vaultName, String location) {
        return this.purgeDeletedWithServiceResponseAsync(vaultName, location).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> purgeDeletedWithServiceResponseAsync(String vaultName, String location) {
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.purgeDeleted(vaultName, location, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginPurgeDeleted(String vaultName, String location) {
        ((ServiceResponse)this.beginPurgeDeletedWithServiceResponseAsync(vaultName, location).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginPurgeDeletedAsync(String vaultName, String location, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPurgeDeletedWithServiceResponseAsync(vaultName, location), serviceCallback);
    }

    public Observable<Void> beginPurgeDeletedAsync(String vaultName, String location) {
        return this.beginPurgeDeletedWithServiceResponseAsync(vaultName, location).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginPurgeDeletedWithServiceResponseAsync(String vaultName, String location) {
        if (vaultName == null) {
            throw new IllegalArgumentException("Parameter vaultName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginPurgeDeleted(vaultName, location, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.beginPurgeDeletedDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginPurgeDeletedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<Resource> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<Resource>((Page)response.body()){

            public Page<Resource> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<Resource>> listAsync(ListOperationCallback<Resource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(String nextPageLink) {
                return VaultsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<Resource>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<Resource>>, Page<Resource>>(){

            public Page<Resource> call(ServiceResponse<Page<Resource>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<Resource>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<Resource>>, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(ServiceResponse<Page<Resource>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Resource>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        String apiVersion = "2015-11-01";
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), "resourceType eq 'Microsoft.KeyVault/vaults'", top, "2015-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<Resource> list(Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(top).toBlocking().single();
        return new PagedList<Resource>((Page)response.body()){

            public Page<Resource> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<Resource>> listAsync(Integer top, ListOperationCallback<Resource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(top), (Func1)new Func1<String, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(String nextPageLink) {
                return VaultsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<Resource>> listAsync(Integer top) {
        return this.listWithServiceResponseAsync(top).map((Func1)new Func1<ServiceResponse<Page<Resource>>, Page<Resource>>(){

            public Page<Resource> call(ServiceResponse<Page<Resource>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<Resource>>> listWithServiceResponseAsync(Integer top) {
        return this.listSinglePageAsync(top).concatMap((Func1)new Func1<ServiceResponse<Page<Resource>>, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(ServiceResponse<Page<Resource>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Resource>>> listSinglePageAsync(Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        String apiVersion = "2015-11-01";
        return this.service.list(this.client.subscriptionId(), "resourceType eq 'Microsoft.KeyVault/vaults'", top, "2015-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Resource>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Resource>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityResultInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>(){

            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return (CheckNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        VaultCheckNameAvailabilityParameters vaultName = new VaultCheckNameAvailabilityParameters();
        vaultName.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), vaultName, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VaultsInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.body()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VaultInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VaultInner>> serviceFuture, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VaultInner> listBySubscriptionNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VaultInner>((Page)response.body()){

            public Page<VaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listBySubscriptionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VaultInner>> listBySubscriptionNextAsync(String nextPageLink, ServiceFuture<List<VaultInner>> serviceFuture, ListOperationCallback<VaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySubscriptionNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listBySubscriptionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VaultInner>> listBySubscriptionNextAsync(String nextPageLink) {
        return this.listBySubscriptionNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Page<VaultInner>>(){

            public Page<VaultInner> call(ServiceResponse<Page<VaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBySubscriptionNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VaultInner>>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(ServiceResponse<Page<VaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listBySubscriptionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VaultInner>>> listBySubscriptionNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBySubscriptionNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VaultInner>>>>(){

            public Observable<ServiceResponse<Page<VaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listBySubscriptionNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VaultInner>> listBySubscriptionNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeletedVaultInner> listDeletedNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listDeletedNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedVaultInner>((Page)response.body()){

            public Page<DeletedVaultInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listDeletedNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeletedVaultInner>> listDeletedNextAsync(String nextPageLink, ServiceFuture<List<DeletedVaultInner>> serviceFuture, ListOperationCallback<DeletedVaultInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listDeletedNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedVaultInner>>>>(){

            public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(String nextPageLink) {
                return VaultsInner.this.listDeletedNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeletedVaultInner>> listDeletedNextAsync(String nextPageLink) {
        return this.listDeletedNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeletedVaultInner>>, Page<DeletedVaultInner>>(){

            public Page<DeletedVaultInner> call(ServiceResponse<Page<DeletedVaultInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedNextWithServiceResponseAsync(String nextPageLink) {
        return this.listDeletedNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedVaultInner>>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>(){

            public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(ServiceResponse<Page<DeletedVaultInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listDeletedNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedVaultInner>>> listDeletedNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listDeletedNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedVaultInner>>>>(){

            public Observable<ServiceResponse<Page<DeletedVaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listDeletedNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedVaultInner>> listDeletedNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedVaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<Resource> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Resource>((Page)response.body()){

            public Page<Resource> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VaultsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<Resource>> listNextAsync(String nextPageLink, ServiceFuture<List<Resource>> serviceFuture, ListOperationCallback<Resource> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(String nextPageLink) {
                return VaultsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<Resource>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<Resource>>, Page<Resource>>(){

            public Page<Resource> call(ServiceResponse<Page<Resource>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<Resource>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<Resource>>, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(ServiceResponse<Page<Resource>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VaultsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Resource>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Resource>>>>(){

            public Observable<ServiceResponse<Page<Resource>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VaultsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Resource>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Resource>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VaultsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body VaultCreateOrUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body VaultCreateOrUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body VaultPatchParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults updateAccessPolicy"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/accessPolicies/{operationKind}")
        public Observable<Response<ResponseBody>> updateAccessPolicy(@Path(value="resourceGroupName") String var1, @Path(value="vaultName") String var2, @Path(value="operationKind") AccessPolicyUpdateKind var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body VaultAccessPolicyParametersInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listBySubscription"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/vaults")
        public Observable<Response<ResponseBody>> listBySubscription(@Path(value="subscriptionId") String var1, @Query(value="$top") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listDeleted"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/deletedVaults")
        public Observable<Response<ResponseBody>> listDeleted(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults getDeleted"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}")
        public Observable<Response<ResponseBody>> getDeleted(@Path(value="vaultName") String var1, @Path(value="location") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults purgeDeleted"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge")
        public Observable<Response<ResponseBody>> purgeDeleted(@Path(value="vaultName") String var1, @Path(value="location") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults beginPurgeDeleted"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge")
        public Observable<Response<ResponseBody>> beginPurgeDeleted(@Path(value="vaultName") String var1, @Path(value="location") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults list"})
        @GET(value="subscriptions/{subscriptionId}/resources")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body VaultCheckNameAvailabilityParameters var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listBySubscriptionNext"})
        @GET
        public Observable<Response<ResponseBody>> listBySubscriptionNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listDeletedNext"})
        @GET
        public Observable<Response<ResponseBody>> listDeletedNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.keyvault.Vaults listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

