/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.locks.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ManagementLocks.
 */
public class ManagementLocksInner implements InnerSupportsGet<ManagementLockObjectInner>, InnerSupportsListing<ManagementLockObjectInner> {
    /** The Retrofit service to perform REST calls. */
    private ManagementLocksService service;
    /** The service client containing this operation class. */
    private ManagementLockClientImpl client;

    /**
     * Initializes an instance of ManagementLocksInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ManagementLocksInner(Retrofit retrofit, ManagementLockClientImpl client) {
        this.service = retrofit.create(ManagementLocksService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ManagementLocks to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ManagementLocksService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateAtResourceGroupLevel" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> createOrUpdateAtResourceGroupLevel(@Path("resourceGroupName") String resourceGroupName, @Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Body ManagementLockObjectInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteAtResourceGroupLevel" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtResourceGroupLevel(@Path("resourceGroupName") String resourceGroupName, @Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateByScope" })
        @PUT("{scope}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> createOrUpdateByScope(@Path("scope") String scope, @Path("lockName") String lockName, @Body ManagementLockObjectInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteByScope" })
        @HTTP(path = "{scope}/providers/Microsoft.Authorization/locks/{lockName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteByScope(@Path("scope") String scope, @Path("lockName") String lockName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getByScope" })
        @GET("{scope}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> getByScope(@Path("scope") String scope, @Path("lockName") String lockName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateAtResourceLevel" })
        @PUT("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> createOrUpdateAtResourceLevel(@Path("resourceGroupName") String resourceGroupName, @Path("resourceProviderNamespace") String resourceProviderNamespace, @Path(value = "parentResourcePath", encoded = true) String parentResourcePath, @Path(value = "resourceType", encoded = true) String resourceType, @Path("resourceName") String resourceName, @Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Body ManagementLockObjectInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteAtResourceLevel" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtResourceLevel(@Path("resourceGroupName") String resourceGroupName, @Path("resourceProviderNamespace") String resourceProviderNamespace, @Path(value = "parentResourcePath", encoded = true) String parentResourcePath, @Path(value = "resourceType", encoded = true) String resourceType, @Path("resourceName") String resourceName, @Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getAtResourceLevel" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> getAtResourceLevel(@Path("resourceGroupName") String resourceGroupName, @Path("resourceProviderNamespace") String resourceProviderNamespace, @Path(value = "parentResourcePath", encoded = true) String parentResourcePath, @Path(value = "resourceType", encoded = true) String resourceType, @Path("resourceName") String resourceName, @Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateAtSubscriptionLevel" })
        @PUT("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> createOrUpdateAtSubscriptionLevel(@Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Body ManagementLockObjectInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteAtSubscriptionLevel" })
        @HTTP(path = "subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtSubscriptionLevel(@Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getAtSubscriptionLevel" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}")
        Observable<Response<ResponseBody>> getAtSubscriptionLevel(@Path("lockName") String lockName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listAtResourceLevel" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks")
        Observable<Response<ResponseBody>> listAtResourceLevel(@Path("resourceGroupName") String resourceGroupName, @Path("resourceProviderNamespace") String resourceProviderNamespace, @Path(value = "parentResourcePath", encoded = true) String parentResourcePath, @Path(value = "resourceType", encoded = true) String resourceType, @Path("resourceName") String resourceName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listAtResourceLevelNext" })
        @GET
        Observable<Response<ResponseBody>> listAtResourceLevelNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates a management lock at the resource group level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner createOrUpdateAtResourceGroupLevel(String resourceGroupName, String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a management lock at the resource group level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelAsync(String resourceGroupName, String lockName, ManagementLockObjectInner parameters, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a management lock at the resource group level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelAsync(String resourceGroupName, String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName, parameters).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a management lock at the resource group level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(String resourceGroupName, String lockName, ManagementLockObjectInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdateAtResourceGroupLevel(resourceGroupName, lockName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = createOrUpdateAtResourceGroupLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .register(201, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a management lock at the resource group level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtResourceGroupLevel(String resourceGroupName, String lockName) {
        deleteAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName).toBlocking().single().body();
    }

    /**
     * Deletes a management lock at the resource group level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtResourceGroupLevelAsync(String resourceGroupName, String lockName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName), serviceCallback);
    }

    /**
     * Deletes a management lock at the resource group level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAtResourceGroupLevelAsync(String resourceGroupName, String lockName) {
        return deleteAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a management lock at the resource group level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAtResourceGroupLevelWithServiceResponseAsync(String resourceGroupName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteAtResourceGroupLevel(resourceGroupName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAtResourceGroupLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAtResourceGroupLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner getByResourceGroup(String resourceGroupName, String lockName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, lockName).toBlocking().single().body();
    }

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> getByResourceGroupAsync(String resourceGroupName, String lockName, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, lockName), serviceCallback);
    }

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> getByResourceGroupAsync(String resourceGroupName, String lockName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, lockName).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions, '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}' for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner createOrUpdateByScope(String scope, String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateByScopeWithServiceResponseAsync(scope, lockName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions, '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}' for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> createOrUpdateByScopeAsync(String scope, String lockName, ManagementLockObjectInner parameters, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateByScopeWithServiceResponseAsync(scope, lockName, parameters), serviceCallback);
    }

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions, '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}' for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> createOrUpdateByScopeAsync(String scope, String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateByScopeWithServiceResponseAsync(scope, lockName, parameters).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions, '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}' for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateByScopeWithServiceResponseAsync(String scope, String lockName, ManagementLockObjectInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdateByScope(scope, lockName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = createOrUpdateByScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateByScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .register(201, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteByScope(String scope, String lockName) {
        deleteByScopeWithServiceResponseAsync(scope, lockName).toBlocking().single().body();
    }

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteByScopeAsync(String scope, String lockName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteByScopeWithServiceResponseAsync(scope, lockName), serviceCallback);
    }

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteByScopeAsync(String scope, String lockName) {
        return deleteByScopeWithServiceResponseAsync(scope, lockName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteByScopeWithServiceResponseAsync(String scope, String lockName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteByScope(scope, lockName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteByScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteByScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner getByScope(String scope, String lockName) {
        return getByScopeWithServiceResponseAsync(scope, lockName).toBlocking().single().body();
    }

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> getByScopeAsync(String scope, String lockName, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByScopeWithServiceResponseAsync(scope, lockName), serviceCallback);
    }

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> getByScopeAsync(String scope, String lockName) {
        return getByScopeWithServiceResponseAsync(scope, lockName).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> getByScopeWithServiceResponseAsync(String scope, String lockName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByScope(scope, lockName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = getByScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> getByScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a management lock at the resource level or any level below the resource.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a  management lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner createOrUpdateAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a management lock at the resource level or any level below the resource.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a  management lock.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> createOrUpdateAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a management lock at the resource level or any level below the resource.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a  management lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> createOrUpdateAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a management lock at the resource level or any level below the resource.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a  management lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdateAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = createOrUpdateAtResourceLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .register(201, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the management lock of a resource or any level below the resource.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        deleteAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).toBlocking().single().body();
    }

    /**
     * Deletes the management lock of a resource or any level below the resource.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName), serviceCallback);
    }

    /**
     * Deletes the management lock of a resource or any level below the resource.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        return deleteAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the management lock of a resource or any level below the resource.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAtResourceLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner getAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        return getAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).toBlocking().single().body();
    }

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> getAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName), serviceCallback);
    }

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> getAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        return getAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> getAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = getAtResourceLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> getAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a management lock at the subscription level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner createOrUpdateAtSubscriptionLevel(String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(lockName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a management lock at the subscription level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelAsync(String lockName, ManagementLockObjectInner parameters, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(lockName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a management lock at the subscription level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelAsync(String lockName, ManagementLockObjectInner parameters) {
        return createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(lockName, parameters).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a management lock at the subscription level.
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(String lockName, ManagementLockObjectInner parameters) {
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdateAtSubscriptionLevel(lockName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = createOrUpdateAtSubscriptionLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the management lock at the subscription level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtSubscriptionLevel(String lockName) {
        deleteAtSubscriptionLevelWithServiceResponseAsync(lockName).toBlocking().single().body();
    }

    /**
     * Deletes the management lock at the subscription level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtSubscriptionLevelAsync(String lockName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtSubscriptionLevelWithServiceResponseAsync(lockName), serviceCallback);
    }

    /**
     * Deletes the management lock at the subscription level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAtSubscriptionLevelAsync(String lockName) {
        return deleteAtSubscriptionLevelWithServiceResponseAsync(lockName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the management lock at the subscription level.
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAtSubscriptionLevelWithServiceResponseAsync(String lockName) {
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteAtSubscriptionLevel(lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAtSubscriptionLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAtSubscriptionLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagementLockObjectInner object if successful.
     */
    public ManagementLockObjectInner getAtSubscriptionLevel(String lockName) {
        return getAtSubscriptionLevelWithServiceResponseAsync(lockName).toBlocking().single().body();
    }

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagementLockObjectInner> getAtSubscriptionLevelAsync(String lockName, final ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtSubscriptionLevelWithServiceResponseAsync(lockName), serviceCallback);
    }

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ManagementLockObjectInner> getAtSubscriptionLevelAsync(String lockName) {
        return getAtSubscriptionLevelWithServiceResponseAsync(lockName).map(new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>() {
            @Override
            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagementLockObjectInner object
     */
    public Observable<ServiceResponse<ManagementLockObjectInner>> getAtSubscriptionLevelWithServiceResponseAsync(String lockName) {
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAtSubscriptionLevel(lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagementLockObjectInner> clientResponse = getAtSubscriptionLevelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagementLockObjectInner> getAtSubscriptionLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagementLockObjectInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagementLockObjectInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listByResourceGroup(final String resourceGroupName, final String filter) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, filter).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param filter The filter to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listByResourceGroupAsync(final String resourceGroupName, final String filter, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listByResourceGroupAsync(final String resourceGroupName, final String filter) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final String filter) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, filter)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param resourceGroupName The name of the resource group containing the locks to get.
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ManagementLockObjectInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listAtResourceLevel(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listAtResourceLevelAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listAtResourceLevelNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listAtResourceLevelAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        return listAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelWithServiceResponseAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        return listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtResourceLevelNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelSinglePageAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listAtResourceLevelDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listAtResourceLevel(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param filter The filter to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listAtResourceLevelAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listAtResourceLevelNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listAtResourceLevelAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        return listAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelWithServiceResponseAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        return listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtResourceLevelNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param resourceGroupName The name of the resource group containing the locked resource. The name is case insensitive.
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param resourceProviderNamespace The namespace of the resource provider.
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param parentResourcePath The parent resource identity.
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param resourceType The resource type of the locked resource.
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param resourceName The name of the locked resource.
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelSinglePageAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listAtResourceLevelDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ManagementLockObjectInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> list() {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listAsync(final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> list(final String filter) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param filter The filter to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listAsync(final String filter, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listSinglePageAsync(final String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ManagementLockObjectInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<ManagementLockObjectInner>> serviceFuture, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a resource group.
     *
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ManagementLockObjectInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listAtResourceLevelNext(final String nextPageLink) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listAtResourceLevelNextAsync(final String nextPageLink, final ServiceFuture<List<ManagementLockObjectInner>> serviceFuture, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtResourceLevelNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listAtResourceLevelNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listAtResourceLevelNextAsync(final String nextPageLink) {
        return listAtResourceLevelNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelNextWithServiceResponseAsync(final String nextPageLink) {
        return listAtResourceLevelNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtResourceLevelNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAtResourceLevelNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listAtResourceLevelNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listAtResourceLevelNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ManagementLockObjectInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object if successful.
     */
    public PagedList<ManagementLockObjectInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ManagementLockObjectInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>(response.body()) {
            @Override
            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagementLockObjectInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ManagementLockObjectInner>> serviceFuture, final ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<Page<ManagementLockObjectInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>() {
                @Override
                public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagementLockObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the management locks for a subscription.
     *
    ServiceResponse<PageImpl<ManagementLockObjectInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagementLockObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ManagementLockObjectInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagementLockObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ManagementLockObjectInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
