/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.monitor.implementation.ActionGroupsInner;
import com.microsoft.azure.management.monitor.implementation.ActivityLogAlertsInner;
import com.microsoft.azure.management.monitor.implementation.ActivityLogsInner;
import com.microsoft.azure.management.monitor.implementation.AlertRuleIncidentsInner;
import com.microsoft.azure.management.monitor.implementation.AlertRulesInner;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingsInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsCategorysInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsInner;
import com.microsoft.azure.management.monitor.implementation.EventCategoriesInner;
import com.microsoft.azure.management.monitor.implementation.LogProfilesInner;
import com.microsoft.azure.management.monitor.implementation.MetricAlertsInner;
import com.microsoft.azure.management.monitor.implementation.MetricAlertsStatusInner;
import com.microsoft.azure.management.monitor.implementation.MetricBaselinesInner;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionsInner;
import com.microsoft.azure.management.monitor.implementation.MetricsInner;
import com.microsoft.azure.management.monitor.implementation.OperationsInner;
import com.microsoft.azure.management.monitor.implementation.TenantActivityLogsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class MonitorManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private AutoscaleSettingsInner autoscaleSettings;
    private OperationsInner operations;
    private AlertRuleIncidentsInner alertRuleIncidents;
    private AlertRulesInner alertRules;
    private LogProfilesInner logProfiles;
    private DiagnosticSettingsInner diagnosticSettings;
    private DiagnosticSettingsCategorysInner diagnosticSettingsCategorys;
    private ActionGroupsInner actionGroups;
    private ActivityLogAlertsInner activityLogAlerts;
    private ActivityLogsInner activityLogs;
    private EventCategoriesInner eventCategories;
    private TenantActivityLogsInner tenantActivityLogs;
    private MetricDefinitionsInner metricDefinitions;
    private MetricsInner metrics;
    private MetricBaselinesInner metricBaselines;
    private MetricAlertsInner metricAlerts;
    private MetricAlertsStatusInner metricAlertsStatus;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public MonitorManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public MonitorManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public MonitorManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public MonitorManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public AutoscaleSettingsInner autoscaleSettings() {
        return this.autoscaleSettings;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public AlertRuleIncidentsInner alertRuleIncidents() {
        return this.alertRuleIncidents;
    }

    public AlertRulesInner alertRules() {
        return this.alertRules;
    }

    public LogProfilesInner logProfiles() {
        return this.logProfiles;
    }

    public DiagnosticSettingsInner diagnosticSettings() {
        return this.diagnosticSettings;
    }

    public DiagnosticSettingsCategorysInner diagnosticSettingsCategorys() {
        return this.diagnosticSettingsCategorys;
    }

    public ActionGroupsInner actionGroups() {
        return this.actionGroups;
    }

    public ActivityLogAlertsInner activityLogAlerts() {
        return this.activityLogAlerts;
    }

    public ActivityLogsInner activityLogs() {
        return this.activityLogs;
    }

    public EventCategoriesInner eventCategories() {
        return this.eventCategories;
    }

    public TenantActivityLogsInner tenantActivityLogs() {
        return this.tenantActivityLogs;
    }

    public MetricDefinitionsInner metricDefinitions() {
        return this.metricDefinitions;
    }

    public MetricsInner metrics() {
        return this.metrics;
    }

    public MetricBaselinesInner metricBaselines() {
        return this.metricBaselines;
    }

    public MetricAlertsInner metricAlerts() {
        return this.metricAlerts;
    }

    public MetricAlertsStatusInner metricAlertsStatus() {
        return this.metricAlertsStatus;
    }

    public MonitorManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public MonitorManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public MonitorManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.autoscaleSettings = new AutoscaleSettingsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.alertRuleIncidents = new AlertRuleIncidentsInner(this.restClient().retrofit(), this);
        this.alertRules = new AlertRulesInner(this.restClient().retrofit(), this);
        this.logProfiles = new LogProfilesInner(this.restClient().retrofit(), this);
        this.diagnosticSettings = new DiagnosticSettingsInner(this.restClient().retrofit(), this);
        this.diagnosticSettingsCategorys = new DiagnosticSettingsCategorysInner(this.restClient().retrofit(), this);
        this.actionGroups = new ActionGroupsInner(this.restClient().retrofit(), this);
        this.activityLogAlerts = new ActivityLogAlertsInner(this.restClient().retrofit(), this);
        this.activityLogs = new ActivityLogsInner(this.restClient().retrofit(), this);
        this.eventCategories = new EventCategoriesInner(this.restClient().retrofit(), this);
        this.tenantActivityLogs = new TenantActivityLogsInner(this.restClient().retrofit(), this);
        this.metricDefinitions = new MetricDefinitionsInner(this.restClient().retrofit(), this);
        this.metrics = new MetricsInner(this.restClient().retrofit(), this);
        this.metricBaselines = new MetricBaselinesInner(this.restClient().retrofit(), this);
        this.metricAlerts = new MetricAlertsInner(this.restClient().retrofit(), this);
        this.metricAlertsStatus = new MetricAlertsStatusInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "MonitorManagementClient");
    }
}

