/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.ActionGroup;
import com.microsoft.azure.management.monitor.AutomationRunbookReceiver;
import com.microsoft.azure.management.monitor.AzureAppPushReceiver;
import com.microsoft.azure.management.monitor.AzureFunctionReceiver;
import com.microsoft.azure.management.monitor.EmailReceiver;
import com.microsoft.azure.management.monitor.ItsmReceiver;
import com.microsoft.azure.management.monitor.LogicAppReceiver;
import com.microsoft.azure.management.monitor.SmsReceiver;
import com.microsoft.azure.management.monitor.VoiceReceiver;
import com.microsoft.azure.management.monitor.WebhookReceiver;
import com.microsoft.azure.management.monitor.implementation.ActionGroupResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class ActionGroupImpl
extends GroupableResourceImpl<ActionGroup, ActionGroupResourceInner, ActionGroupImpl, MonitorManager>
implements ActionGroup,
ActionGroup.Definition,
ActionGroup.Update,
ActionGroup.UpdateStages.WithActionUpdateDefinition {
    private final String emailSuffix = "_-EmailAction-";
    private final String smsSuffix = "_-SMSAction-";
    private final String appActionSuffix = "_-AzureAppAction-";
    private final String voiceSuffix = "_-VoiceAction-";
    private final String runBookSuffix = " (RB)";
    private final String logicSuffix = " (LA)";
    private final String functionSuffix = " (F)";
    private final String webhookSuffix = " (WH)";
    private final String itsmSuffix = " (ITSM)";
    private String actionReceiverPrefix = "";
    private TreeMap<String, EmailReceiver> emailReceivers = new TreeMap();
    private TreeMap<String, SmsReceiver> smsReceivers = new TreeMap();
    private TreeMap<String, AzureAppPushReceiver> appActionReceivers = new TreeMap();
    private TreeMap<String, VoiceReceiver> voiceReceivers = new TreeMap();
    private TreeMap<String, AutomationRunbookReceiver> runBookReceivers = new TreeMap();
    private TreeMap<String, LogicAppReceiver> logicReceivers = new TreeMap();
    private TreeMap<String, AzureFunctionReceiver> functionReceivers = new TreeMap();
    private TreeMap<String, WebhookReceiver> webhookReceivers = new TreeMap();
    private TreeMap<String, ItsmReceiver> itsmReceivers = new TreeMap();

    ActionGroupImpl(String name, ActionGroupResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Resource)innerModel, (ManagerBase)monitorManager);
        if (this.isInCreateMode()) {
            ((ActionGroupResourceInner)((Object)this.inner())).withEnabled(true);
            ((ActionGroupResourceInner)((Object)this.inner())).withGroupShortName(this.name().substring(0, this.name().length() > 12 ? 12 : this.name().length()));
        } else {
            this.withExistingResourceGroup(ResourceUtils.groupFromResourceId((String)this.id()));
        }
    }

    @Override
    public String shortName() {
        return ((ActionGroupResourceInner)((Object)this.inner())).groupShortName();
    }

    @Override
    public List<EmailReceiver> emailReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).emailReceivers();
    }

    @Override
    public List<SmsReceiver> smsReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).smsReceivers();
    }

    @Override
    public List<WebhookReceiver> webhookReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).webhookReceivers();
    }

    @Override
    public List<ItsmReceiver> itsmReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).itsmReceivers();
    }

    @Override
    public List<AzureAppPushReceiver> azureAppPushReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).azureAppPushReceivers();
    }

    @Override
    public List<AutomationRunbookReceiver> automationRunbookReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).automationRunbookReceivers();
    }

    @Override
    public List<VoiceReceiver> voiceReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).voiceReceivers();
    }

    @Override
    public List<LogicAppReceiver> logicAppReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).logicAppReceivers();
    }

    @Override
    public List<AzureFunctionReceiver> azureFunctionReceivers() {
        return ((ActionGroupResourceInner)((Object)this.inner())).azureFunctionReceivers();
    }

    @Override
    public ActionGroupImpl withoutReceiver(String actionNamePrefix) {
        this.updateReceiver(actionNamePrefix);
        this.withoutEmail();
        this.withoutSms();
        this.withoutAzureAppPush();
        this.withoutVoice();
        this.withoutAutomationRunbook();
        this.withoutLogicApp();
        this.withoutAzureFunction();
        this.withoutWebhook();
        this.withoutItsm();
        return this.parent();
    }

    public ActionGroupImpl defineReceiver(String actionNamePrefix) {
        return this.updateReceiver(actionNamePrefix);
    }

    @Override
    public ActionGroupImpl updateReceiver(String actionNamePrefix) {
        this.actionReceiverPrefix = actionNamePrefix;
        this.emailReceivers.clear();
        this.smsReceivers.clear();
        this.appActionReceivers.clear();
        this.voiceReceivers.clear();
        this.runBookReceivers.clear();
        this.logicReceivers.clear();
        this.functionReceivers.clear();
        this.webhookReceivers.clear();
        this.itsmReceivers.clear();
        if (((ActionGroupResourceInner)((Object)this.inner())).emailReceivers() != null) {
            for (EmailReceiver emailReceiver : ((ActionGroupResourceInner)((Object)this.inner())).emailReceivers()) {
                this.emailReceivers.put(emailReceiver.name(), emailReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).smsReceivers() != null) {
            for (SmsReceiver smsReceiver : ((ActionGroupResourceInner)((Object)this.inner())).smsReceivers()) {
                this.smsReceivers.put(smsReceiver.name(), smsReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).azureAppPushReceivers() != null) {
            for (AzureAppPushReceiver azureAppPushReceiver : ((ActionGroupResourceInner)((Object)this.inner())).azureAppPushReceivers()) {
                this.appActionReceivers.put(azureAppPushReceiver.name(), azureAppPushReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).voiceReceivers() != null) {
            for (VoiceReceiver voiceReceiver : ((ActionGroupResourceInner)((Object)this.inner())).voiceReceivers()) {
                this.voiceReceivers.put(voiceReceiver.name(), voiceReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).automationRunbookReceivers() != null) {
            for (AutomationRunbookReceiver automationRunbookReceiver : ((ActionGroupResourceInner)((Object)this.inner())).automationRunbookReceivers()) {
                this.runBookReceivers.put(automationRunbookReceiver.name(), automationRunbookReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).logicAppReceivers() != null) {
            for (LogicAppReceiver logicAppReceiver : ((ActionGroupResourceInner)((Object)this.inner())).logicAppReceivers()) {
                this.logicReceivers.put(logicAppReceiver.name(), logicAppReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).azureFunctionReceivers() != null) {
            for (AzureFunctionReceiver azureFunctionReceiver : ((ActionGroupResourceInner)((Object)this.inner())).azureFunctionReceivers()) {
                this.functionReceivers.put(azureFunctionReceiver.name(), azureFunctionReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).webhookReceivers() != null) {
            for (WebhookReceiver webhookReceiver : ((ActionGroupResourceInner)((Object)this.inner())).webhookReceivers()) {
                this.webhookReceivers.put(webhookReceiver.name(), webhookReceiver);
            }
        }
        if (((ActionGroupResourceInner)((Object)this.inner())).itsmReceivers() != null) {
            for (ItsmReceiver itsmReceiver : ((ActionGroupResourceInner)((Object)this.inner())).itsmReceivers()) {
                this.itsmReceivers.put(itsmReceiver.name(), itsmReceiver);
            }
        }
        return this;
    }

    @Override
    public ActionGroupImpl withShortName(String shortName) {
        ((ActionGroupResourceInner)((Object)this.inner())).withGroupShortName(shortName);
        return this;
    }

    public Observable<ActionGroup> createResourceAsync() {
        ((ActionGroupResourceInner)((Object)this.inner())).withLocation("global");
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).actionGroups().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ActionGroupResourceInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ActionGroupResourceInner> getInnerAsync() {
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).actionGroups().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ActionGroupImpl withEmail(String emailAddress) {
        this.withoutEmail();
        String compositeKey = this.actionReceiverPrefix + "_-EmailAction-";
        EmailReceiver er = new EmailReceiver();
        er.withName(compositeKey);
        er.withEmailAddress(emailAddress);
        this.emailReceivers.put(compositeKey, er);
        return this;
    }

    @Override
    public ActionGroupImpl withSms(String countryCode, String phoneNumber) {
        this.withoutSms();
        String compositeKey = this.actionReceiverPrefix + "_-SMSAction-";
        SmsReceiver sr = new SmsReceiver();
        sr.withName(compositeKey);
        sr.withCountryCode(countryCode);
        sr.withPhoneNumber(phoneNumber);
        this.smsReceivers.put(compositeKey, sr);
        return this;
    }

    @Override
    public ActionGroupImpl withWebhook(String serviceUri) {
        this.withoutWebhook();
        String compositeKey = this.actionReceiverPrefix + " (WH)";
        WebhookReceiver wr = new WebhookReceiver();
        wr.withName(compositeKey);
        wr.withServiceUri(serviceUri);
        this.webhookReceivers.put(compositeKey, wr);
        return this;
    }

    @Override
    public ActionGroupImpl withItsm(String workspaceId, String connectionId, String ticketConfiguration, String region) {
        this.withoutItsm();
        String compositeKey = this.actionReceiverPrefix + " (ITSM)";
        ItsmReceiver ir = new ItsmReceiver();
        ir.withName(compositeKey);
        ir.withWorkspaceId(workspaceId);
        ir.withConnectionId(connectionId);
        ir.withRegion(region);
        ir.withTicketConfiguration(ticketConfiguration);
        this.itsmReceivers.put(compositeKey, ir);
        return this;
    }

    @Override
    public ActionGroupImpl withAzureAppPush(String emailAddress) {
        this.withoutAzureAppPush();
        String compositeKey = this.actionReceiverPrefix + "_-AzureAppAction-";
        AzureAppPushReceiver ar = new AzureAppPushReceiver();
        ar.withName(compositeKey);
        ar.withEmailAddress(emailAddress);
        this.appActionReceivers.put(compositeKey, ar);
        return this;
    }

    @Override
    public ActionGroupImpl withAutomationRunbook(String automationAccountId, String runbookName, String webhookResourceId, boolean isGlobalRunbook) {
        this.withoutAutomationRunbook();
        String compositeKey = this.actionReceiverPrefix + " (RB)";
        AutomationRunbookReceiver arr = new AutomationRunbookReceiver();
        arr.withName(compositeKey);
        arr.withAutomationAccountId(automationAccountId);
        arr.withRunbookName(runbookName);
        arr.withWebhookResourceId(webhookResourceId);
        arr.withIsGlobalRunbook(isGlobalRunbook);
        this.runBookReceivers.put(compositeKey, arr);
        return this;
    }

    @Override
    public ActionGroupImpl withVoice(String countryCode, String phoneNumber) {
        this.withoutVoice();
        String compositeKey = this.actionReceiverPrefix + "_-VoiceAction-";
        VoiceReceiver vr = new VoiceReceiver();
        vr.withName(compositeKey);
        vr.withCountryCode(countryCode);
        vr.withPhoneNumber(phoneNumber);
        this.voiceReceivers.put(compositeKey, vr);
        return this;
    }

    @Override
    public ActionGroupImpl withLogicApp(String logicAppResourceId, String callbackUrl) {
        this.withoutLogicApp();
        String compositeKey = this.actionReceiverPrefix + " (LA)";
        LogicAppReceiver lr = new LogicAppReceiver();
        lr.withName(compositeKey);
        lr.withResourceId(logicAppResourceId);
        lr.withCallbackUrl(callbackUrl);
        this.logicReceivers.put(compositeKey, lr);
        return this;
    }

    @Override
    public ActionGroupImpl withAzureFunction(String functionAppResourceId, String functionName, String httpTriggerUrl) {
        this.withoutAzureFunction();
        String compositeKey = this.actionReceiverPrefix + " (F)";
        AzureFunctionReceiver afr = new AzureFunctionReceiver();
        afr.withName(compositeKey);
        afr.withFunctionAppResourceId(functionAppResourceId);
        afr.withFunctionName(functionName);
        afr.withHttpTriggerUrl(httpTriggerUrl);
        this.functionReceivers.put(compositeKey, afr);
        return this;
    }

    public ActionGroupImpl attach() {
        this.actionReceiverPrefix = "";
        this.populateReceivers();
        this.emailReceivers.clear();
        this.smsReceivers.clear();
        this.appActionReceivers.clear();
        this.voiceReceivers.clear();
        this.runBookReceivers.clear();
        this.logicReceivers.clear();
        this.functionReceivers.clear();
        this.webhookReceivers.clear();
        this.itsmReceivers.clear();
        return this;
    }

    @Override
    public ActionGroupImpl withoutEmail() {
        String compositeKey = this.actionReceiverPrefix + "_-EmailAction-";
        if (this.emailReceivers.containsKey(compositeKey)) {
            this.emailReceivers.remove(compositeKey);
        }
        if (this.emailReceivers.containsKey(this.actionReceiverPrefix)) {
            this.emailReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutSms() {
        String compositeKey = this.actionReceiverPrefix + "_-SMSAction-";
        if (this.smsReceivers.containsKey(compositeKey)) {
            this.smsReceivers.remove(compositeKey);
        }
        if (this.smsReceivers.containsKey(this.actionReceiverPrefix)) {
            this.smsReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutWebhook() {
        String compositeKey = this.actionReceiverPrefix + " (WH)";
        if (this.webhookReceivers.containsKey(compositeKey)) {
            this.webhookReceivers.remove(compositeKey);
        }
        if (this.webhookReceivers.containsKey(this.actionReceiverPrefix)) {
            this.webhookReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutItsm() {
        String compositeKey = this.actionReceiverPrefix + " (ITSM)";
        if (this.itsmReceivers.containsKey(compositeKey)) {
            this.itsmReceivers.remove(compositeKey);
        }
        if (this.itsmReceivers.containsKey(this.actionReceiverPrefix)) {
            this.itsmReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutAzureAppPush() {
        String compositeKey = this.actionReceiverPrefix + "_-AzureAppAction-";
        if (this.appActionReceivers.containsKey(compositeKey)) {
            this.appActionReceivers.remove(compositeKey);
        }
        if (this.appActionReceivers.containsKey(this.actionReceiverPrefix)) {
            this.appActionReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutAutomationRunbook() {
        String compositeKey = this.actionReceiverPrefix + " (RB)";
        if (this.runBookReceivers.containsKey(compositeKey)) {
            this.runBookReceivers.remove(compositeKey);
        }
        if (this.runBookReceivers.containsKey(this.actionReceiverPrefix)) {
            this.runBookReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutVoice() {
        String compositeKey = this.actionReceiverPrefix + "_-VoiceAction-";
        if (this.voiceReceivers.containsKey(compositeKey)) {
            this.voiceReceivers.remove(compositeKey);
        }
        if (this.voiceReceivers.containsKey(this.actionReceiverPrefix)) {
            this.voiceReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutLogicApp() {
        String compositeKey = this.actionReceiverPrefix + " (LA)";
        if (this.logicReceivers.containsKey(compositeKey)) {
            this.logicReceivers.remove(compositeKey);
        }
        if (this.logicReceivers.containsKey(this.actionReceiverPrefix)) {
            this.logicReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl withoutAzureFunction() {
        String compositeKey = this.actionReceiverPrefix + " (LA)";
        if (this.functionReceivers.containsKey(compositeKey)) {
            this.functionReceivers.remove(compositeKey);
        }
        if (this.functionReceivers.containsKey(this.actionReceiverPrefix)) {
            this.functionReceivers.remove(this.actionReceiverPrefix);
        }
        return this;
    }

    @Override
    public ActionGroupImpl parent() {
        return this.attach();
    }

    private void populateReceivers() {
        if (this.emailReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).emailReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withEmailReceivers(new ArrayList<EmailReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).emailReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).emailReceivers().addAll(this.emailReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withEmailReceivers(null);
        }
        if (this.smsReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).smsReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withSmsReceivers(new ArrayList<SmsReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).smsReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).smsReceivers().addAll(this.smsReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withSmsReceivers(null);
        }
        if (this.appActionReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).azureAppPushReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withAzureAppPushReceivers(new ArrayList<AzureAppPushReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).azureAppPushReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).azureAppPushReceivers().addAll(this.appActionReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withAzureAppPushReceivers(null);
        }
        if (this.voiceReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).voiceReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withVoiceReceivers(new ArrayList<VoiceReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).voiceReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).voiceReceivers().addAll(this.voiceReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withVoiceReceivers(null);
        }
        if (this.runBookReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).automationRunbookReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withAutomationRunbookReceivers(new ArrayList<AutomationRunbookReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).automationRunbookReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).automationRunbookReceivers().addAll(this.runBookReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withAutomationRunbookReceivers(null);
        }
        if (this.logicReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).logicAppReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withLogicAppReceivers(new ArrayList<LogicAppReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).logicAppReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).logicAppReceivers().addAll(this.logicReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withLogicAppReceivers(null);
        }
        if (this.functionReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).azureFunctionReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withAzureFunctionReceivers(new ArrayList<AzureFunctionReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).azureFunctionReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).azureFunctionReceivers().addAll(this.functionReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withAzureFunctionReceivers(null);
        }
        if (this.webhookReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).webhookReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withWebhookReceivers(new ArrayList<WebhookReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).webhookReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).webhookReceivers().addAll(this.webhookReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withWebhookReceivers(null);
        }
        if (this.itsmReceivers.values().size() > 0) {
            if (((ActionGroupResourceInner)((Object)this.inner())).itsmReceivers() == null) {
                ((ActionGroupResourceInner)((Object)this.inner())).withItsmReceivers(new ArrayList<ItsmReceiver>());
            } else {
                ((ActionGroupResourceInner)((Object)this.inner())).itsmReceivers().clear();
            }
            ((ActionGroupResourceInner)((Object)this.inner())).itsmReceivers().addAll(this.itsmReceivers.values());
        } else {
            ((ActionGroupResourceInner)((Object)this.inner())).withItsmReceivers(null);
        }
    }
}

