/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsResourceCollectionInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DiagnosticSettingsInner
implements InnerSupportsDelete<Void> {
    private DiagnosticSettingsService service;
    private MonitorManagementClientImpl client;

    public DiagnosticSettingsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (DiagnosticSettingsService)retrofit.create(DiagnosticSettingsService.class);
        this.client = client;
    }

    public DiagnosticSettingsResourceInner get(String resourceUri, String name) {
        return (DiagnosticSettingsResourceInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceUri, name).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticSettingsResourceInner> getAsync(String resourceUri, String name, ServiceCallback<DiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceUri, name), serviceCallback);
    }

    public Observable<DiagnosticSettingsResourceInner> getAsync(String resourceUri, String name) {
        return this.getWithServiceResponseAsync(resourceUri, name).map((Func1)new Func1<ServiceResponse<DiagnosticSettingsResourceInner>, DiagnosticSettingsResourceInner>(){

            public DiagnosticSettingsResourceInner call(ServiceResponse<DiagnosticSettingsResourceInner> response) {
                return (DiagnosticSettingsResourceInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticSettingsResourceInner>> getWithServiceResponseAsync(String resourceUri, String name) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        String apiVersion = "2017-05-01-preview";
        return this.service.get(resourceUri, name, "2017-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticSettingsResourceInner>>>(){

            public Observable<ServiceResponse<DiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticSettingsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticSettingsResourceInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticSettingsResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public DiagnosticSettingsResourceInner createOrUpdate(String resourceUri, String name, DiagnosticSettingsResourceInner parameters) {
        return (DiagnosticSettingsResourceInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceUri, name, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticSettingsResourceInner> createOrUpdateAsync(String resourceUri, String name, DiagnosticSettingsResourceInner parameters, ServiceCallback<DiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceUri, name, parameters), serviceCallback);
    }

    public Observable<DiagnosticSettingsResourceInner> createOrUpdateAsync(String resourceUri, String name, DiagnosticSettingsResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceUri, name, parameters).map((Func1)new Func1<ServiceResponse<DiagnosticSettingsResourceInner>, DiagnosticSettingsResourceInner>(){

            public DiagnosticSettingsResourceInner call(ServiceResponse<DiagnosticSettingsResourceInner> response) {
                return (DiagnosticSettingsResourceInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticSettingsResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceUri, String name, DiagnosticSettingsResourceInner parameters) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-05-01-preview";
        return this.service.createOrUpdate(resourceUri, name, "2017-05-01-preview", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticSettingsResourceInner>>>(){

            public Observable<ServiceResponse<DiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticSettingsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticSettingsResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticSettingsResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceUri, String name) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceUri, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceUri, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceUri, name), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceUri, String name) {
        return this.deleteWithServiceResponseAsync(resourceUri, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceUri, String name) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        String apiVersion = "2017-05-01-preview";
        return this.service.delete(resourceUri, name, "2017-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticSettingsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public DiagnosticSettingsResourceCollectionInner list(String resourceUri) {
        return (DiagnosticSettingsResourceCollectionInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticSettingsResourceCollectionInner> listAsync(String resourceUri, ServiceCallback<DiagnosticSettingsResourceCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<DiagnosticSettingsResourceCollectionInner> listAsync(String resourceUri) {
        return this.listWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<DiagnosticSettingsResourceCollectionInner>, DiagnosticSettingsResourceCollectionInner>(){

            public DiagnosticSettingsResourceCollectionInner call(ServiceResponse<DiagnosticSettingsResourceCollectionInner> response) {
                return (DiagnosticSettingsResourceCollectionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticSettingsResourceCollectionInner>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2017-05-01-preview";
        return this.service.list(resourceUri, "2017-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticSettingsResourceCollectionInner>>>(){

            public Observable<ServiceResponse<DiagnosticSettingsResourceCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticSettingsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticSettingsResourceCollectionInner> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticSettingsResourceCollectionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface DiagnosticSettingsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.DiagnosticSettings get"})
        @GET(value="{resourceUri}/providers/microsoft.insights/diagnosticSettings/{name}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceUri", encoded=true) String var1, @Path(value="name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.DiagnosticSettings createOrUpdate"})
        @PUT(value="{resourceUri}/providers/microsoft.insights/diagnosticSettings/{name}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceUri", encoded=true) String var1, @Path(value="name") String var2, @Query(value="api-version") String var3, @Body DiagnosticSettingsResourceInner var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.DiagnosticSettings delete"})
        @HTTP(path="{resourceUri}/providers/microsoft.insights/diagnosticSettings/{name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceUri", encoded=true) String var1, @Path(value="name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.DiagnosticSettings list"})
        @GET(value="{resourceUri}/providers/microsoft.insights/diagnosticSettings")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceUri", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

