/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.CategoryType;
import com.microsoft.azure.management.monitor.DiagnosticSetting;
import com.microsoft.azure.management.monitor.DiagnosticSettingsCategory;
import com.microsoft.azure.management.monitor.LogSettings;
import com.microsoft.azure.management.monitor.MetricSettings;
import com.microsoft.azure.management.monitor.RetentionPolicy;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.joda.time.Period;
import rx.Observable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Monitor.Fluent.Models")
class DiagnosticSettingImpl
extends CreatableUpdatableImpl<DiagnosticSetting, DiagnosticSettingsResourceInner, DiagnosticSettingImpl>
implements DiagnosticSetting,
DiagnosticSetting.Definition,
DiagnosticSetting.Update {
    public static final String DIAGNOSTIC_SETTINGS_URI = "/providers/microsoft.insights/diagnosticSettings/";
    private String resourceId;
    private TreeMap<String, MetricSettings> metricSet;
    private TreeMap<String, LogSettings> logSet;
    private final MonitorManager myManager;

    DiagnosticSettingImpl(String name, DiagnosticSettingsResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Object)innerModel);
        this.myManager = monitorManager;
        this.initializeSets();
    }

    @Override
    public DiagnosticSettingImpl withResource(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public DiagnosticSettingImpl withStorageAccount(String storageAccountId) {
        ((DiagnosticSettingsResourceInner)this.inner()).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withLogAnalytics(String workspaceId) {
        ((DiagnosticSettingsResourceInner)this.inner()).withWorkspaceId(workspaceId);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutLogAnalytics() {
        ((DiagnosticSettingsResourceInner)this.inner()).withWorkspaceId(null);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutStorageAccount() {
        ((DiagnosticSettingsResourceInner)this.inner()).withStorageAccountId(null);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withEventHub(String eventHubAuthorizationRuleId) {
        ((DiagnosticSettingsResourceInner)this.inner()).withEventHubAuthorizationRuleId(eventHubAuthorizationRuleId);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withEventHub(String eventHubAuthorizationRuleId, String eventHubName) {
        this.withEventHub(eventHubAuthorizationRuleId);
        ((DiagnosticSettingsResourceInner)this.inner()).withEventHubName(eventHubName);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutEventHub() {
        ((DiagnosticSettingsResourceInner)this.inner()).withEventHubAuthorizationRuleId(null);
        ((DiagnosticSettingsResourceInner)this.inner()).withEventHubName(null);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withMetric(String category, Period timeGrain, int retentionDays) {
        MetricSettings nm = new MetricSettings();
        nm.withCategory(category);
        nm.withEnabled(true);
        nm.withRetentionPolicy(new RetentionPolicy());
        nm.retentionPolicy().withDays(retentionDays);
        if (retentionDays > 0) {
            nm.retentionPolicy().withEnabled(true);
        }
        nm.withTimeGrain(timeGrain);
        this.metricSet.put(category, nm);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withLog(String category, int retentionDays) {
        LogSettings nl = new LogSettings();
        nl.withCategory(category);
        nl.withEnabled(true);
        nl.withRetentionPolicy(new RetentionPolicy());
        nl.retentionPolicy().withDays(retentionDays);
        if (retentionDays > 0) {
            nl.retentionPolicy().withEnabled(true);
        }
        this.logSet.put(category, nl);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withLogsAndMetrics(List<DiagnosticSettingsCategory> categories, Period timeGrain, int retentionDays) {
        for (DiagnosticSettingsCategory dsc : categories) {
            if (dsc.type() == CategoryType.METRICS) {
                this.withMetric(dsc.name(), timeGrain, retentionDays);
                continue;
            }
            if (dsc.type() == CategoryType.LOGS) {
                this.withLog(dsc.name(), retentionDays);
                continue;
            }
            throw new UnsupportedOperationException(dsc.type().toString() + " is unsupported.");
        }
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutMetric(String category) {
        this.metricSet.remove(category);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutLog(String category) {
        this.logSet.remove(category);
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutLogs() {
        this.logSet.clear();
        return this;
    }

    @Override
    public DiagnosticSettingImpl withoutMetrics() {
        this.metricSet.clear();
        return this;
    }

    public String id() {
        return ((DiagnosticSettingsResourceInner)this.inner()).id();
    }

    @Override
    public String resourceId() {
        return this.resourceId;
    }

    @Override
    public String storageAccountId() {
        return ((DiagnosticSettingsResourceInner)this.inner()).storageAccountId();
    }

    @Override
    public String eventHubAuthorizationRuleId() {
        return ((DiagnosticSettingsResourceInner)this.inner()).eventHubAuthorizationRuleId();
    }

    @Override
    public String eventHubName() {
        return ((DiagnosticSettingsResourceInner)this.inner()).eventHubName();
    }

    @Override
    public List<MetricSettings> metrics() {
        if (((DiagnosticSettingsResourceInner)this.inner()).metrics() == null) {
            return null;
        }
        return Collections.unmodifiableList(((DiagnosticSettingsResourceInner)this.inner()).metrics());
    }

    @Override
    public List<LogSettings> logs() {
        if (((DiagnosticSettingsResourceInner)this.inner()).logs() == null) {
            return null;
        }
        return Collections.unmodifiableList(((DiagnosticSettingsResourceInner)this.inner()).logs());
    }

    @Override
    public String workspaceId() {
        return ((DiagnosticSettingsResourceInner)this.inner()).workspaceId();
    }

    public MonitorManager manager() {
        return this.myManager;
    }

    public boolean isInCreateMode() {
        return ((DiagnosticSettingsResourceInner)this.inner()).id() == null;
    }

    public Observable<DiagnosticSetting> createResourceAsync() {
        ((DiagnosticSettingsResourceInner)this.inner()).withLogs(new ArrayList<LogSettings>(this.logSet.values()));
        ((DiagnosticSettingsResourceInner)this.inner()).withMetrics(new ArrayList<MetricSettings>(this.metricSet.values()));
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().createOrUpdateAsync(this.resourceId, this.name(), (DiagnosticSettingsResourceInner)this.inner()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<DiagnosticSettingsResourceInner> getInnerAsync() {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().getAsync(this.resourceId, this.name());
    }

    public void setInner(DiagnosticSettingsResourceInner inner) {
        super.setInner((Object)inner);
        this.initializeSets();
        this.metricSet.clear();
        this.logSet.clear();
        if (!this.isInCreateMode()) {
            this.resourceId = inner.id().substring(0, ((DiagnosticSettingsResourceInner)this.inner()).id().length() - (DIAGNOSTIC_SETTINGS_URI + ((DiagnosticSettingsResourceInner)this.inner()).name()).length());
            for (MetricSettings ms : ((DiagnosticSettingsResourceInner)this.inner()).metrics()) {
                this.metricSet.put(ms.category(), ms);
            }
            for (LogSettings ls : ((DiagnosticSettingsResourceInner)this.inner()).logs()) {
                this.logSet.put(ls.category(), ls);
            }
        }
    }

    private void initializeSets() {
        if (this.metricSet == null) {
            this.metricSet = new TreeMap();
        }
        if (this.logSet == null) {
            this.logSet = new TreeMap();
        }
    }
}

