/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import org.joda.time.Period;
import java.util.List;
import org.joda.time.DateTime;
import com.microsoft.azure.management.monitor.Baseline;
import com.microsoft.azure.management.monitor.BaselineMetadataValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The response to a baseline query.
 */
@JsonFlatten
public class BaselineResponseInner {
    /**
     * the metric baseline Id.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /**
     * the resource type of the baseline resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * the name and the display name of the metric, i.e. it is localizable
     * string.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private LocalizableStringInner name;

    /**
     * The timespan for which the data was retrieved. Its value consists of two
     * datatimes concatenated, separated by '/'.  This may be adjusted in the
     * future and returned back from what was originally requested.
     */
    @JsonProperty(value = "properties.timespan")
    private String timespan;

    /**
     * The interval (window size) for which the metric data was returned in.
     * This may be adjusted in the future and returned back from what was
     * originally requested.  This is not present if a metadata request was
     * made.
     */
    @JsonProperty(value = "properties.interval")
    private Period interval;

    /**
     * The aggregation type of the metric.
     */
    @JsonProperty(value = "properties.aggregation")
    private String aggregation;

    /**
     * the array of timestamps of the baselines.
     */
    @JsonProperty(value = "properties.timestamps")
    private List<DateTime> timestamps;

    /**
     * the baseline values for each sensitivity.
     */
    @JsonProperty(value = "properties.baseline")
    private List<Baseline> baseline;

    /**
     * the baseline metadata values.
     */
    @JsonProperty(value = "properties.metadata")
    private List<BaselineMetadataValue> metadata;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public LocalizableStringInner name() {
        return this.name;
    }

    /**
     * Get the timespan value.
     *
     * @return the timespan value
     */
    public String timespan() {
        return this.timespan;
    }

    /**
     * Set the timespan value.
     *
     * @param timespan the timespan value to set
     * @return the BaselineResponseInner object itself.
     */
    public BaselineResponseInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    /**
     * Get the interval value.
     *
     * @return the interval value
     */
    public Period interval() {
        return this.interval;
    }

    /**
     * Set the interval value.
     *
     * @param interval the interval value to set
     * @return the BaselineResponseInner object itself.
     */
    public BaselineResponseInner withInterval(Period interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the aggregation value.
     *
     * @return the aggregation value
     */
    public String aggregation() {
        return this.aggregation;
    }

    /**
     * Set the aggregation value.
     *
     * @param aggregation the aggregation value to set
     * @return the BaselineResponseInner object itself.
     */
    public BaselineResponseInner withAggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    /**
     * Get the timestamps value.
     *
     * @return the timestamps value
     */
    public List<DateTime> timestamps() {
        return this.timestamps;
    }

    /**
     * Set the timestamps value.
     *
     * @param timestamps the timestamps value to set
     * @return the BaselineResponseInner object itself.
     */
    public BaselineResponseInner withTimestamps(List<DateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    /**
     * Get the baseline value.
     *
     * @return the baseline value
     */
    public List<Baseline> baseline() {
        return this.baseline;
    }

    /**
     * Set the baseline value.
     *
     * @param baseline the baseline value to set
     * @return the BaselineResponseInner object itself.
     */
    public BaselineResponseInner withBaseline(List<Baseline> baseline) {
        this.baseline = baseline;
        return this;
    }

    /**
     * Get the metadata value.
     *
     * @return the metadata value
     */
    public List<BaselineMetadataValue> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata value.
     *
     * @param metadata the metadata value to set
     * @return the BaselineResponseInner object itself.
     */
    public BaselineResponseInner withMetadata(List<BaselineMetadataValue> metadata) {
        this.metadata = metadata;
        return this;
    }

}
