/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.LangMethodDefinition;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.monitor.MetricAlertCondition;
import com.microsoft.azure.management.monitor.implementation.MetricAlertResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Collection;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Period;

@Fluent
public interface MetricAlert
extends GroupableResource<MonitorManager, MetricAlertResourceInner>,
Refreshable<MetricAlert>,
Updatable<Update> {
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String description();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public int severity();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public boolean enabled();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public Collection<String> scopes();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public Period evaluationFrequency();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public Period windowSize();

    public Map<String, MetricAlertCondition> alertCriterias();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public boolean autoMitigate();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public Collection<String> actionGroupIds();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public DateTime lastUpdatedTime();

    public static interface Update
    extends Appliable<MetricAlert>,
    UpdateStages.WithMetricUpdate,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithMetricUpdate {
            public Update withPeriod(Period var1);

            public Update withFrequency(Period var1);

            public Update withSeverity(int var1);

            public Update withDescription(String var1);

            @Method
            public Update withRuleEnabled();

            @Method
            public Update withRuleDisabled();

            public Update withActionGroups(String ... var1);

            public Update withoutActionGroup(String var1);

            public MetricAlertCondition.UpdateDefinitionStages.Blank.MetricName<Update> defineAlertCriteria(String var1);

            public MetricAlertCondition.UpdateStages updateAlertCriteria(String var1);

            public Update withoutAlertCriteria(String var1);

            @Method
            public Update withAutoMitigation();

            @Method
            public Update withoutAutoMitigation();
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<MetricAlert>,
        Resource.DefinitionWithTags<WithCreate>,
        WithCriteriaDefinition {
            @Method
            public WithCreate withoutAutoMitigation();

            @Method
            public WithActionGroup withRuleDisabled();
        }

        public static interface WithCriteriaDefinition {
            public MetricAlertCondition.DefinitionStages.Blank.MetricName<WithCreate> defineAlertCriteria(String var1);
        }

        public static interface WithActionGroup {
            public WithCriteriaDefinition withActionGroups(String ... var1);
        }

        public static interface WithSeverity {
            public WithActionGroup withAlertDetails(int var1, String var2);
        }

        public static interface WithEvaluationFrequency {
            public WithSeverity withFrequency(Period var1);
        }

        public static interface WithWindowSize {
            public WithEvaluationFrequency withPeriod(Period var1);
        }

        public static interface WithScopes {
            public WithWindowSize withTargetResource(String var1);

            public WithWindowSize withTargetResource(HasId var1);
        }

        public static interface Blank
        extends GroupableResource.DefinitionStages.WithGroupAndRegion<WithScopes> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate,
    DefinitionStages.WithScopes,
    DefinitionStages.WithWindowSize,
    DefinitionStages.WithEvaluationFrequency,
    DefinitionStages.WithSeverity,
    DefinitionStages.WithActionGroup,
    DefinitionStages.WithCriteriaDefinition {
    }
}

