/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.MetricAlert;
import com.microsoft.azure.management.monitor.MetricAlertCondition;
import com.microsoft.azure.management.monitor.MetricAlertRuleCondition;
import com.microsoft.azure.management.monitor.MetricAlertRuleTimeAggregation;
import com.microsoft.azure.management.monitor.MetricCriteria;
import com.microsoft.azure.management.monitor.MetricDimension;
import com.microsoft.azure.management.monitor.implementation.MetricAlertImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;

@LangDefinition
class MetricAlertConditionImpl
extends WrapperImpl<MetricCriteria>
implements MetricAlertCondition,
MetricAlertCondition.DefinitionStages,
MetricAlertCondition.DefinitionStages.Blank.MetricName<MetricAlert.DefinitionStages.WithCreate>,
MetricAlertCondition.DefinitionStages.WithCriteriaOperator<MetricAlert.DefinitionStages.WithCreate>,
MetricAlertCondition.DefinitionStages.WithConditionAttach<MetricAlert.DefinitionStages.WithCreate>,
MetricAlertCondition.UpdateDefinitionStages,
MetricAlertCondition.UpdateDefinitionStages.Blank.MetricName<MetricAlert.Update>,
MetricAlertCondition.UpdateDefinitionStages.WithCriteriaOperator<MetricAlert.Update>,
MetricAlertCondition.UpdateDefinitionStages.WithConditionAttach<MetricAlert.Update>,
MetricAlertCondition.UpdateStages {
    private final MetricAlertImpl parent;
    private TreeMap<String, MetricDimension> dimensions;

    MetricAlertConditionImpl(String name, MetricCriteria innerObject, MetricAlertImpl parent) {
        super((Object)innerObject);
        ((MetricCriteria)this.inner()).withName(name);
        this.parent = parent;
        this.dimensions = new TreeMap();
        if (((MetricCriteria)this.inner()).dimensions() != null) {
            for (MetricDimension md : ((MetricCriteria)this.inner()).dimensions()) {
                this.dimensions.put(md.name(), md);
            }
        }
    }

    @Override
    public MetricAlertConditionImpl withCondition(MetricAlertRuleCondition condition, MetricAlertRuleTimeAggregation timeAggregation, double threshold) {
        ((MetricCriteria)this.inner()).withOperator(condition);
        ((MetricCriteria)this.inner()).withTimeAggregation(timeAggregation);
        ((MetricCriteria)this.inner()).withThreshold(threshold);
        return this;
    }

    public MetricAlertConditionImpl withMetricName(String metricName, String metricNamespace) {
        ((MetricCriteria)this.inner()).withMetricNamespace(metricNamespace);
        return this.withMetricName(metricName);
    }

    public MetricAlertConditionImpl withMetricName(String metricName) {
        ((MetricCriteria)this.inner()).withMetricName(metricName);
        return this;
    }

    @Override
    public MetricAlertConditionImpl withDimension(String dimensionName, String ... values) {
        if (this.dimensions.containsKey(dimensionName)) {
            this.dimensions.remove(dimensionName);
        }
        MetricDimension md = new MetricDimension();
        md.withName(dimensionName);
        md.withOperator("Include");
        md.withValues(Arrays.asList(values));
        this.dimensions.put(dimensionName, md);
        return this;
    }

    @Override
    public MetricAlertConditionImpl withoutDimension(String dimensionName) {
        if (this.dimensions.containsKey(dimensionName)) {
            this.dimensions.remove(dimensionName);
        }
        return this;
    }

    @Override
    public MetricAlertImpl parent() {
        ((MetricCriteria)this.inner()).withDimensions(new ArrayList<MetricDimension>(this.dimensions.values()));
        return this.parent;
    }

    @Override
    public MetricAlertImpl attach() {
        ((MetricCriteria)this.inner()).withDimensions(new ArrayList<MetricDimension>(this.dimensions.values()));
        return this.parent().withAlertCriteria(this);
    }

    @Override
    public String name() {
        return ((MetricCriteria)this.inner()).name();
    }

    @Override
    public String metricName() {
        return ((MetricCriteria)this.inner()).metricName();
    }

    @Override
    public String metricNamespace() {
        return ((MetricCriteria)this.inner()).metricNamespace();
    }

    @Override
    public MetricAlertRuleCondition condition() {
        return ((MetricCriteria)this.inner()).operator();
    }

    @Override
    public MetricAlertRuleTimeAggregation timeAggregation() {
        return ((MetricCriteria)this.inner()).timeAggregation();
    }

    @Override
    public double threshold() {
        return ((MetricCriteria)this.inner()).threshold();
    }

    @Override
    public Collection<MetricDimension> dimensions() {
        return this.dimensions.values();
    }
}

