/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;

/**
 * Initializes a new instance of the MonitorClientImpl class.
 */
public class MonitorClientImpl extends AzureServiceClient {
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** The Azure subscription Id. */
    private String subscriptionId;

    /**
     * Gets The Azure subscription Id.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Sets The Azure subscription Id.
     *
     * @param subscriptionId the subscriptionId value.
     * @return the service client itself
     */
    public MonitorClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /** Gets or sets the preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets Gets or sets the preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets Gets or sets the preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public MonitorClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public MonitorClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public MonitorClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The UsageMetricsInner object to access its operations.
     */
    private UsageMetricsInner usageMetrics;

    /**
     * Gets the UsageMetricsInner object to access its operations.
     * @return the UsageMetricsInner object.
     */
    public UsageMetricsInner usageMetrics() {
        return this.usageMetrics;
    }

    /**
     * The EventCategoriesInner object to access its operations.
     */
    private EventCategoriesInner eventCategories;

    /**
     * Gets the EventCategoriesInner object to access its operations.
     * @return the EventCategoriesInner object.
     */
    public EventCategoriesInner eventCategories() {
        return this.eventCategories;
    }

    /**
     * The ActivityLogsInner object to access its operations.
     */
    private ActivityLogsInner activityLogs;

    /**
     * Gets the ActivityLogsInner object to access its operations.
     * @return the ActivityLogsInner object.
     */
    public ActivityLogsInner activityLogs() {
        return this.activityLogs;
    }

    /**
     * The TenantActivityLogsInner object to access its operations.
     */
    private TenantActivityLogsInner tenantActivityLogs;

    /**
     * Gets the TenantActivityLogsInner object to access its operations.
     * @return the TenantActivityLogsInner object.
     */
    public TenantActivityLogsInner tenantActivityLogs() {
        return this.tenantActivityLogs;
    }

    /**
     * The MetricDefinitionsInner object to access its operations.
     */
    private MetricDefinitionsInner metricDefinitions;

    /**
     * Gets the MetricDefinitionsInner object to access its operations.
     * @return the MetricDefinitionsInner object.
     */
    public MetricDefinitionsInner metricDefinitions() {
        return this.metricDefinitions;
    }

    /**
     * The MetricsInner object to access its operations.
     */
    private MetricsInner metrics;

    /**
     * Gets the MetricsInner object to access its operations.
     * @return the MetricsInner object.
     */
    public MetricsInner metrics() {
        return this.metrics;
    }

    /**
     * Initializes an instance of MonitorClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public MonitorClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    /**
     * Initializes an instance of MonitorClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    public MonitorClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of MonitorClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public MonitorClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.usageMetrics = new UsageMetricsInner(restClient().retrofit(), this);
        this.eventCategories = new EventCategoriesInner(restClient().retrofit(), this);
        this.activityLogs = new ActivityLogsInner(restClient().retrofit(), this);
        this.tenantActivityLogs = new TenantActivityLogsInner(restClient().retrofit(), this);
        this.metricDefinitions = new MetricDefinitionsInner(restClient().retrofit(), this);
        this.metrics = new MetricsInner(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "MonitorClient");
    }
}
