/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import org.joda.time.DateTime;
import org.joda.time.Period;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Usage Metric data.
 */
public class UsageMetricInner {
    /**
     * the usage metric name and display name.
     */
    @JsonProperty(value = "name")
    private LocalizableStringInner name;

    /**
     * the current value for the usage metric.
     */
    @JsonProperty(value = "currentValue")
    private Double currentValue;

    /**
     * the id for the usage metric.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * the quota limit the usage metric.
     */
    @JsonProperty(value = "limit")
    private Double limit;

    /**
     * the unit for the usage metric.
     */
    @JsonProperty(value = "unit")
    private String unit;

    /**
     * the next reset time for the current value.
     */
    @JsonProperty(value = "nextResetTime")
    private DateTime nextResetTime;

    /**
     * the amount of time it takes to reset the value.
     */
    @JsonProperty(value = "quotaPeriod")
    private Period quotaPeriod;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public LocalizableStringInner name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withName(LocalizableStringInner name) {
        this.name = name;
        return this;
    }

    /**
     * Get the currentValue value.
     *
     * @return the currentValue value
     */
    public Double currentValue() {
        return this.currentValue;
    }

    /**
     * Set the currentValue value.
     *
     * @param currentValue the currentValue value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withCurrentValue(Double currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the limit value.
     *
     * @return the limit value
     */
    public Double limit() {
        return this.limit;
    }

    /**
     * Set the limit value.
     *
     * @param limit the limit value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withLimit(Double limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Get the unit value.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit value.
     *
     * @param unit the unit value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the nextResetTime value.
     *
     * @return the nextResetTime value
     */
    public DateTime nextResetTime() {
        return this.nextResetTime;
    }

    /**
     * Set the nextResetTime value.
     *
     * @param nextResetTime the nextResetTime value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withNextResetTime(DateTime nextResetTime) {
        this.nextResetTime = nextResetTime;
        return this;
    }

    /**
     * Get the quotaPeriod value.
     *
     * @return the quotaPeriod value
     */
    public Period quotaPeriod() {
        return this.quotaPeriod;
    }

    /**
     * Set the quotaPeriod value.
     *
     * @param quotaPeriod the quotaPeriod value to set
     * @return the UsageMetricInner object itself.
     */
    public UsageMetricInner withQuotaPeriod(Period quotaPeriod) {
        this.quotaPeriod = quotaPeriod;
        return this;
    }

}
