/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.monitor.implementation.MonitorClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MetricDefinitionsInner {
    private MetricDefinitionsService service;
    private MonitorClientImpl client;

    public MetricDefinitionsInner(Retrofit retrofit, MonitorClientImpl client) {
        this.service = (MetricDefinitionsService)retrofit.create(MetricDefinitionsService.class);
        this.client = client;
    }

    public List<MetricDefinitionInner> list(String resourceUri) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listAsync(String resourceUri, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listAsync(String resourceUri) {
        return this.listWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        String filter = null;
        return this.service.list(resourceUri, "2016-03-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MetricDefinitionsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<MetricDefinitionInner> list(String resourceUri, String filter) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listAsync(String resourceUri, String filter, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri, filter), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listAsync(String resourceUri, String filter) {
        return this.listWithServiceResponseAsync(resourceUri, filter).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listWithServiceResponseAsync(String resourceUri, String filter) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.list(resourceUri, "2016-03-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MetricDefinitionsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface MetricDefinitionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricDefinitions list"})
        @GET(value="{resourceUri}/providers/microsoft.insights/metricDefinitions")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceUri", encoded=true) String var1, @Query(value="api-version") String var2, @Query(value="$filter") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

