/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.ServiceDiagnosticSettingsResourceInner;
import com.microsoft.azure.management.monitor.implementation.ServiceDiagnosticSettingsResourcePatchInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServiceDiagnosticSettingsInner {
    private ServiceDiagnosticSettingsService service;
    private MonitorManagementClientImpl client;

    public ServiceDiagnosticSettingsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (ServiceDiagnosticSettingsService)retrofit.create(ServiceDiagnosticSettingsService.class);
        this.client = client;
    }

    public ServiceDiagnosticSettingsResourceInner get(String resourceUri) {
        return (ServiceDiagnosticSettingsResourceInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceUri).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceDiagnosticSettingsResourceInner> getAsync(String resourceUri, ServiceCallback<ServiceDiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<ServiceDiagnosticSettingsResourceInner> getAsync(String resourceUri) {
        return this.getWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<ServiceDiagnosticSettingsResourceInner>, ServiceDiagnosticSettingsResourceInner>(){

            public ServiceDiagnosticSettingsResourceInner call(ServiceResponse<ServiceDiagnosticSettingsResourceInner> response) {
                return (ServiceDiagnosticSettingsResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> getWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2016-09-01";
        return this.service.get(resourceUri, "2016-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>>>(){

            public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceDiagnosticSettingsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceDiagnosticSettingsResourceInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceDiagnosticSettingsResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ServiceDiagnosticSettingsResourceInner createOrUpdate(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters) {
        return (ServiceDiagnosticSettingsResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceUri, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceDiagnosticSettingsResourceInner> createOrUpdateAsync(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters, ServiceCallback<ServiceDiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceUri, parameters), serviceCallback);
    }

    public Observable<ServiceDiagnosticSettingsResourceInner> createOrUpdateAsync(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceUri, parameters).map((Func1)new Func1<ServiceResponse<ServiceDiagnosticSettingsResourceInner>, ServiceDiagnosticSettingsResourceInner>(){

            public ServiceDiagnosticSettingsResourceInner call(ServiceResponse<ServiceDiagnosticSettingsResourceInner> response) {
                return (ServiceDiagnosticSettingsResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-09-01";
        return this.service.createOrUpdate(resourceUri, "2016-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>>>(){

            public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceDiagnosticSettingsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceDiagnosticSettingsResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceDiagnosticSettingsResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServiceDiagnosticSettingsResourceInner update(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource) {
        return (ServiceDiagnosticSettingsResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceUri, serviceDiagnosticSettingsResource).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceDiagnosticSettingsResourceInner> updateAsync(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource, ServiceCallback<ServiceDiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceUri, serviceDiagnosticSettingsResource), serviceCallback);
    }

    public Observable<ServiceDiagnosticSettingsResourceInner> updateAsync(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource) {
        return this.updateWithServiceResponseAsync(resourceUri, serviceDiagnosticSettingsResource).map((Func1)new Func1<ServiceResponse<ServiceDiagnosticSettingsResourceInner>, ServiceDiagnosticSettingsResourceInner>(){

            public ServiceDiagnosticSettingsResourceInner call(ServiceResponse<ServiceDiagnosticSettingsResourceInner> response) {
                return (ServiceDiagnosticSettingsResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> updateWithServiceResponseAsync(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (serviceDiagnosticSettingsResource == null) {
            throw new IllegalArgumentException("Parameter serviceDiagnosticSettingsResource is required and cannot be null.");
        }
        Validator.validate((Object)serviceDiagnosticSettingsResource);
        String apiVersion = "2016-09-01";
        return this.service.update(resourceUri, "2016-09-01", serviceDiagnosticSettingsResource, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>>>(){

            public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceDiagnosticSettingsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceDiagnosticSettingsResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceDiagnosticSettingsResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ServiceDiagnosticSettingsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ServiceDiagnosticSettings get"})
        @GET(value="{resourceUri}/providers/microsoft.insights/diagnosticSettings/service")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceUri") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ServiceDiagnosticSettings createOrUpdate"})
        @PUT(value="{resourceUri}/providers/microsoft.insights/diagnosticSettings/service")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceUri") String var1, @Query(value="api-version") String var2, @Body ServiceDiagnosticSettingsResourceInner var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ServiceDiagnosticSettings update"})
        @PATCH(value="{resourceUri}/providers/microsoft.insights/diagnosticSettings/service")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceUri") String var1, @Query(value="api-version") String var2, @Body ServiceDiagnosticSettingsResourcePatchInner var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

