/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.monitor.EnableRequest;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ActionGroups.
 */
public class ActionGroupsInner implements InnerSupportsGet<ActionGroupResourceInner>, InnerSupportsDelete<Void> {
    /** The Retrofit service to perform REST calls. */
    private ActionGroupsService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of ActionGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ActionGroupsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(ActionGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ActionGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ActionGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("actionGroupName") String actionGroupName, @Path("subscriptionId") String subscriptionId, @Body ActionGroupResourceInner actionGroup, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("actionGroupName") String actionGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("actionGroupName") String actionGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups listBySubscriptionId" })
        @GET("subscriptions/{subscriptionId}/providers/microsoft.insights/actionGroups")
        Observable<Response<ResponseBody>> listBySubscriptionId(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups enableReceiver" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}/subscribe")
        Observable<Response<ResponseBody>> enableReceiver(@Path("resourceGroupName") String resourceGroupName, @Path("actionGroupName") String actionGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body EnableRequest enableRequest, @Header("User-Agent") String userAgent);

    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ActionGroupResourceInner object if successful.
     */
    public ActionGroupResourceInner createOrUpdate(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroup).toBlocking().single().body();
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ActionGroupResourceInner> createOrUpdateAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, final ServiceCallback<ActionGroupResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroup), serviceCallback);
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ActionGroupResourceInner object
     */
    public Observable<ActionGroupResourceInner> createOrUpdateAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroup).map(new Func1<ServiceResponse<ActionGroupResourceInner>, ActionGroupResourceInner>() {
            @Override
            public ActionGroupResourceInner call(ServiceResponse<ActionGroupResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ActionGroupResourceInner object
     */
    public Observable<ServiceResponse<ActionGroupResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (actionGroup == null) {
            throw new IllegalArgumentException("Parameter actionGroup is required and cannot be null.");
        }
        Validator.validate(actionGroup);
        final String apiVersion = "2017-04-01";
        return service.createOrUpdate(resourceGroupName, actionGroupName, this.client.subscriptionId(), actionGroup, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActionGroupResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<ActionGroupResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ActionGroupResourceInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ActionGroupResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ActionGroupResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ActionGroupResourceInner>() { }.getType())
                .register(201, new TypeToken<ActionGroupResourceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ActionGroupResourceInner object if successful.
     */
    public ActionGroupResourceInner getByResourceGroup(String resourceGroupName, String actionGroupName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, actionGroupName).toBlocking().single().body();
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName, final ServiceCallback<ActionGroupResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, actionGroupName), serviceCallback);
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ActionGroupResourceInner object
     */
    public Observable<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, actionGroupName).map(new Func1<ServiceResponse<ActionGroupResourceInner>, ActionGroupResourceInner>() {
            @Override
            public ActionGroupResourceInner call(ServiceResponse<ActionGroupResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ActionGroupResourceInner object
     */
    public Observable<ServiceResponse<ActionGroupResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String actionGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-04-01";
        return service.getByResourceGroup(resourceGroupName, actionGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActionGroupResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<ActionGroupResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ActionGroupResourceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ActionGroupResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ActionGroupResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ActionGroupResourceInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String actionGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, actionGroupName).toBlocking().single().body();
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String actionGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, actionGroupName), serviceCallback);
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String actionGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, actionGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String actionGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-04-01";
        return service.delete(resourceGroupName, actionGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;ActionGroupResourceInner&gt; object if successful.
     */
    public List<ActionGroupResourceInner> listBySubscriptionId() {
        return listBySubscriptionIdWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ActionGroupResourceInner>> listBySubscriptionIdAsync(final ServiceCallback<List<ActionGroupResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listBySubscriptionIdWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;ActionGroupResourceInner&gt; object
     */
    public Observable<List<ActionGroupResourceInner>> listBySubscriptionIdAsync() {
        return listBySubscriptionIdWithServiceResponseAsync().map(new Func1<ServiceResponse<List<ActionGroupResourceInner>>, List<ActionGroupResourceInner>>() {
            @Override
            public List<ActionGroupResourceInner> call(ServiceResponse<List<ActionGroupResourceInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;ActionGroupResourceInner&gt; object
     */
    public Observable<ServiceResponse<List<ActionGroupResourceInner>>> listBySubscriptionIdWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-04-01";
        return service.listBySubscriptionId(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ActionGroupResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ActionGroupResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ActionGroupResourceInner>> result = listBySubscriptionIdDelegate(response);
                        ServiceResponse<List<ActionGroupResourceInner>> clientResponse = new ServiceResponse<List<ActionGroupResourceInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ActionGroupResourceInner>> listBySubscriptionIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ActionGroupResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ActionGroupResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;ActionGroupResourceInner&gt; object if successful.
     */
    public List<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single().body();
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ActionGroupResourceInner>> listByResourceGroupAsync(String resourceGroupName, final ServiceCallback<List<ActionGroupResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;ActionGroupResourceInner&gt; object
     */
    public Observable<List<ActionGroupResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName).map(new Func1<ServiceResponse<List<ActionGroupResourceInner>>, List<ActionGroupResourceInner>>() {
            @Override
            public List<ActionGroupResourceInner> call(ServiceResponse<List<ActionGroupResourceInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;ActionGroupResourceInner&gt; object
     */
    public Observable<ServiceResponse<List<ActionGroupResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-04-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ActionGroupResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ActionGroupResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ActionGroupResourceInner>> result = listByResourceGroupDelegate(response);
                        ServiceResponse<List<ActionGroupResourceInner>> clientResponse = new ServiceResponse<List<ActionGroupResourceInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ActionGroupResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ActionGroupResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ActionGroupResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param receiverName The name of the receiver to resubscribe.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void enableReceiver(String resourceGroupName, String actionGroupName, String receiverName) {
        enableReceiverWithServiceResponseAsync(resourceGroupName, actionGroupName, receiverName).toBlocking().single().body();
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param receiverName The name of the receiver to resubscribe.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, String receiverName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(enableReceiverWithServiceResponseAsync(resourceGroupName, actionGroupName, receiverName), serviceCallback);
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param receiverName The name of the receiver to resubscribe.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, String receiverName) {
        return enableReceiverWithServiceResponseAsync(resourceGroupName, actionGroupName, receiverName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled.
     *
     * @param resourceGroupName The name of the resource group.
     * @param actionGroupName The name of the action group.
     * @param receiverName The name of the receiver to resubscribe.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> enableReceiverWithServiceResponseAsync(String resourceGroupName, String actionGroupName, String receiverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (receiverName == null) {
            throw new IllegalArgumentException("Parameter receiverName is required and cannot be null.");
        }
        final String apiVersion = "2017-04-01";
        EnableRequest enableRequest = new EnableRequest();
        enableRequest.withReceiverName(receiverName);
        return service.enableReceiver(resourceGroupName, actionGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), enableRequest, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = enableReceiverDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> enableReceiverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
