/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.monitor.AutoscaleSettingResourcePatch;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in AutoscaleSettings.
 */
public class AutoscaleSettingsInner implements InnerSupportsGet<AutoscaleSettingResourceInner>, InnerSupportsDelete<Void>, InnerSupportsListing<AutoscaleSettingResourceInner> {
    /** The Retrofit service to perform REST calls. */
    private AutoscaleSettingsService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of AutoscaleSettingsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AutoscaleSettingsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(AutoscaleSettingsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AutoscaleSettings to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AutoscaleSettingsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("autoscaleSettingName") String autoscaleSettingName, @Path("subscriptionId") String subscriptionId, @Body AutoscaleSettingResourceInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("autoscaleSettingName") String autoscaleSettingName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("autoscaleSettingName") String autoscaleSettingName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings update" })
        @PATCH("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("autoscaleSettingName") String autoscaleSettingName, @Query("api-version") String apiVersion, @Body AutoscaleSettingResourcePatch autoscaleSettingResource, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings list" })
        @GET("subscriptions/{subscriptionId}/providers/microsoft.insights/autoscalesettings")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object if successful.
     */
    public PagedList<AutoscaleSettingResourceInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<AutoscaleSettingResourceInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<AutoscaleSettingResourceInner>(response.body()) {
            @Override
            public Page<AutoscaleSettingResourceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoscaleSettingResourceInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<Page<AutoscaleSettingResourceInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Page<AutoscaleSettingResourceInner>>() {
                @Override
                public Page<AutoscaleSettingResourceInner> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
    ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-04-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoscaleSettingResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoscaleSettingResourceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoscaleSettingResourceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates or updates an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param parameters Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AutoscaleSettingResourceInner object if successful.
     */
    public AutoscaleSettingResourceInner createOrUpdate(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param parameters Parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AutoscaleSettingResourceInner> createOrUpdateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters, final ServiceCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param parameters Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AutoscaleSettingResourceInner object
     */
    public Observable<AutoscaleSettingResourceInner> createOrUpdateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, parameters).map(new Func1<ServiceResponse<AutoscaleSettingResourceInner>, AutoscaleSettingResourceInner>() {
            @Override
            public AutoscaleSettingResourceInner call(ServiceResponse<AutoscaleSettingResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param parameters Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AutoscaleSettingResourceInner object
     */
    public Observable<ServiceResponse<AutoscaleSettingResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-04-01";
        return service.createOrUpdate(resourceGroupName, autoscaleSettingName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AutoscaleSettingResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AutoscaleSettingResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AutoscaleSettingResourceInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AutoscaleSettingResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AutoscaleSettingResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AutoscaleSettingResourceInner>() { }.getType())
                .register(201, new TypeToken<AutoscaleSettingResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes and autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String autoscaleSettingName) {
        deleteWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).toBlocking().single().body();
    }

    /**
     * Deletes and autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String autoscaleSettingName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, autoscaleSettingName), serviceCallback);
    }

    /**
     * Deletes and autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String autoscaleSettingName) {
        return deleteWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes and autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-04-01";
        return service.delete(resourceGroupName, autoscaleSettingName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AutoscaleSettingResourceInner object if successful.
     */
    public AutoscaleSettingResourceInner getByResourceGroup(String resourceGroupName, String autoscaleSettingName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).toBlocking().single().body();
    }

    /**
     * Gets an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AutoscaleSettingResourceInner> getByResourceGroupAsync(String resourceGroupName, String autoscaleSettingName, final ServiceCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, autoscaleSettingName), serviceCallback);
    }

    /**
     * Gets an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AutoscaleSettingResourceInner object
     */
    public Observable<AutoscaleSettingResourceInner> getByResourceGroupAsync(String resourceGroupName, String autoscaleSettingName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).map(new Func1<ServiceResponse<AutoscaleSettingResourceInner>, AutoscaleSettingResourceInner>() {
            @Override
            public AutoscaleSettingResourceInner call(ServiceResponse<AutoscaleSettingResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an autoscale setting.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AutoscaleSettingResourceInner object
     */
    public Observable<ServiceResponse<AutoscaleSettingResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-04-01";
        return service.getByResourceGroup(resourceGroupName, autoscaleSettingName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AutoscaleSettingResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AutoscaleSettingResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AutoscaleSettingResourceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AutoscaleSettingResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AutoscaleSettingResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AutoscaleSettingResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing AutoscaleSettingsResource. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param autoscaleSettingResource Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AutoscaleSettingResourceInner object if successful.
     */
    public AutoscaleSettingResourceInner update(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatch autoscaleSettingResource) {
        return updateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, autoscaleSettingResource).toBlocking().single().body();
    }

    /**
     * Updates an existing AutoscaleSettingsResource. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param autoscaleSettingResource Parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AutoscaleSettingResourceInner> updateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatch autoscaleSettingResource, final ServiceCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, autoscaleSettingResource), serviceCallback);
    }

    /**
     * Updates an existing AutoscaleSettingsResource. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param autoscaleSettingResource Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AutoscaleSettingResourceInner object
     */
    public Observable<AutoscaleSettingResourceInner> updateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatch autoscaleSettingResource) {
        return updateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, autoscaleSettingResource).map(new Func1<ServiceResponse<AutoscaleSettingResourceInner>, AutoscaleSettingResourceInner>() {
            @Override
            public AutoscaleSettingResourceInner call(ServiceResponse<AutoscaleSettingResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing AutoscaleSettingsResource. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param autoscaleSettingName The autoscale setting name.
     * @param autoscaleSettingResource Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AutoscaleSettingResourceInner object
     */
    public Observable<ServiceResponse<AutoscaleSettingResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatch autoscaleSettingResource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (autoscaleSettingResource == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingResource is required and cannot be null.");
        }
        Validator.validate(autoscaleSettingResource);
        final String apiVersion = "2015-04-01";
        return service.update(this.client.subscriptionId(), resourceGroupName, autoscaleSettingName, apiVersion, autoscaleSettingResource, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AutoscaleSettingResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AutoscaleSettingResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AutoscaleSettingResourceInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AutoscaleSettingResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AutoscaleSettingResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AutoscaleSettingResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object if successful.
     */
    public PagedList<AutoscaleSettingResourceInner> list() {
        ServiceResponse<Page<AutoscaleSettingResourceInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<AutoscaleSettingResourceInner>(response.body()) {
            @Override
            public Page<AutoscaleSettingResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoscaleSettingResourceInner>> listAsync(final ListOperationCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<Page<AutoscaleSettingResourceInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Page<AutoscaleSettingResourceInner>>() {
                @Override
                public Page<AutoscaleSettingResourceInner> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-04-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoscaleSettingResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoscaleSettingResourceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoscaleSettingResourceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object if successful.
     */
    public PagedList<AutoscaleSettingResourceInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<AutoscaleSettingResourceInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoscaleSettingResourceInner>(response.body()) {
            @Override
            public Page<AutoscaleSettingResourceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoscaleSettingResourceInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<AutoscaleSettingResourceInner>> serviceFuture, final ListOperationCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<Page<AutoscaleSettingResourceInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Page<AutoscaleSettingResourceInner>>() {
                @Override
                public Page<AutoscaleSettingResourceInner> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the autoscale settings for a resource group.
     *
    ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoscaleSettingResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoscaleSettingResourceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoscaleSettingResourceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object if successful.
     */
    public PagedList<AutoscaleSettingResourceInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<AutoscaleSettingResourceInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoscaleSettingResourceInner>(response.body()) {
            @Override
            public Page<AutoscaleSettingResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoscaleSettingResourceInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<AutoscaleSettingResourceInner>> serviceFuture, final ListOperationCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<Page<AutoscaleSettingResourceInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Page<AutoscaleSettingResourceInner>>() {
                @Override
                public Page<AutoscaleSettingResourceInner> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoscaleSettingResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the autoscale settings for a subscription.
     *
    ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoscaleSettingResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoscaleSettingResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoscaleSettingResourceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoscaleSettingResourceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
