/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.MetricAlertResourcePatch;
import com.microsoft.azure.management.monitor.implementation.MetricAlertResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MetricAlertsInner
implements InnerSupportsGet<MetricAlertResourceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<MetricAlertResourceInner> {
    private MetricAlertsService service;
    private MonitorManagementClientImpl client;

    public MetricAlertsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (MetricAlertsService)retrofit.create(MetricAlertsService.class);
        this.client = client;
    }

    public PagedList<MetricAlertResourceInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<MetricAlertResourceInner>(page){

            public Page<MetricAlertResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<MetricAlertResourceInner>> listAsync(ServiceCallback<List<MetricAlertResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<MetricAlertResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<MetricAlertResourceInner>>, Page<MetricAlertResourceInner>>(){

            public Page<MetricAlertResourceInner> call(ServiceResponse<List<MetricAlertResourceInner>> response) {
                PageImpl1<MetricAlertResourceInner> page = new PageImpl1<MetricAlertResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<MetricAlertResourceInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.list(this.client.subscriptionId(), "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricAlertResourceInner>>>>(){

            public Observable<ServiceResponse<List<MetricAlertResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MetricAlertsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<MetricAlertResourceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<MetricAlertResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<MetricAlertResourceInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<MetricAlertResourceInner>(page){

            public Page<MetricAlertResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<MetricAlertResourceInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<MetricAlertResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<MetricAlertResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<MetricAlertResourceInner>>, Page<MetricAlertResourceInner>>(){

            public Page<MetricAlertResourceInner> call(ServiceResponse<List<MetricAlertResourceInner>> response) {
                PageImpl1<MetricAlertResourceInner> page = new PageImpl1<MetricAlertResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<MetricAlertResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricAlertResourceInner>>>>(){

            public Observable<ServiceResponse<List<MetricAlertResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MetricAlertsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<MetricAlertResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<MetricAlertResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public MetricAlertResourceInner getByResourceGroup(String resourceGroupName, String ruleName) {
        return (MetricAlertResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body());
    }

    public ServiceFuture<MetricAlertResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName, ServiceCallback<MetricAlertResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<MetricAlertResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<MetricAlertResourceInner>, MetricAlertResourceInner>(){

            public MetricAlertResourceInner call(ServiceResponse<MetricAlertResourceInner> response) {
                return (MetricAlertResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MetricAlertResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricAlertResourceInner>>>(){

            public Observable<ServiceResponse<MetricAlertResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricAlertsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MetricAlertResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MetricAlertResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public MetricAlertResourceInner createOrUpdate(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters) {
        return (MetricAlertResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<MetricAlertResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters, ServiceCallback<MetricAlertResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    public Observable<MetricAlertResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map((Func1)new Func1<ServiceResponse<MetricAlertResourceInner>, MetricAlertResourceInner>(){

            public MetricAlertResourceInner call(ServiceResponse<MetricAlertResourceInner> response) {
                return (MetricAlertResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MetricAlertResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-03-01";
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-03-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricAlertResourceInner>>>(){

            public Observable<ServiceResponse<MetricAlertResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricAlertsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MetricAlertResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MetricAlertResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public MetricAlertResourceInner update(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters) {
        return (MetricAlertResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<MetricAlertResourceInner> updateAsync(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters, ServiceCallback<MetricAlertResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    public Observable<MetricAlertResourceInner> updateAsync(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map((Func1)new Func1<ServiceResponse<MetricAlertResourceInner>, MetricAlertResourceInner>(){

            public MetricAlertResourceInner call(ServiceResponse<MetricAlertResourceInner> response) {
                return (MetricAlertResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MetricAlertResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-03-01";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-03-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricAlertResourceInner>>>(){

            public Observable<ServiceResponse<MetricAlertResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricAlertsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MetricAlertResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MetricAlertResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String ruleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String ruleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricAlertsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface MetricAlertsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlerts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Insights/metricAlerts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlerts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlerts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlerts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Body MetricAlertResourceInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlerts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Body MetricAlertResourcePatch var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlerts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

