/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in UsageMetrics.
 */
public class UsageMetricsInner {
    /** The Retrofit service to perform REST calls. */
    private UsageMetricsService service;
    /** The service client containing this operation class. */
    private MonitorClientImpl client;

    /**
     * Initializes an instance of UsageMetricsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public UsageMetricsInner(Retrofit retrofit, MonitorClientImpl client) {
        this.service = retrofit.create(UsageMetricsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for UsageMetrics to be
     * used by Retrofit to perform actually REST calls.
     */
    interface UsageMetricsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.UsageMetrics list" })
        @GET("{resourceUri}/usages")
        Observable<Response<ResponseBody>> list(@Path(value = "resourceUri", encoded = true) String resourceUri, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;UsageMetricInner&gt; object if successful.
     */
    public List<UsageMetricInner> list(String resourceUri, String apiVersion) {
        return listWithServiceResponseAsync(resourceUri, apiVersion).toBlocking().single().body();
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion, final ServiceCallback<List<UsageMetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceUri, apiVersion), serviceCallback);
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageMetricInner&gt; object
     */
    public Observable<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion) {
        return listWithServiceResponseAsync(resourceUri, apiVersion).map(new Func1<ServiceResponse<List<UsageMetricInner>>, List<UsageMetricInner>>() {
            @Override
            public List<UsageMetricInner> call(ServiceResponse<List<UsageMetricInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageMetricInner&gt; object
     */
    public Observable<ServiceResponse<List<UsageMetricInner>>> listWithServiceResponseAsync(String resourceUri, String apiVersion) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        final String filter = null;
        return service.list(resourceUri, apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<UsageMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageMetricInner>> result = listDelegate(response);
                        ServiceResponse<List<UsageMetricInner>> clientResponse = new ServiceResponse<List<UsageMetricInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @param filter The filter to apply on the operation.&lt;br&gt;**WARNING**: $filter not documented since the operation will be deprecated in the next release.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;UsageMetricInner&gt; object if successful.
     */
    public List<UsageMetricInner> list(String resourceUri, String apiVersion, String filter) {
        return listWithServiceResponseAsync(resourceUri, apiVersion, filter).toBlocking().single().body();
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @param filter The filter to apply on the operation.&lt;br&gt;**WARNING**: $filter not documented since the operation will be deprecated in the next release.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion, String filter, final ServiceCallback<List<UsageMetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceUri, apiVersion, filter), serviceCallback);
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @param filter The filter to apply on the operation.&lt;br&gt;**WARNING**: $filter not documented since the operation will be deprecated in the next release.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageMetricInner&gt; object
     */
    public Observable<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion, String filter) {
        return listWithServiceResponseAsync(resourceUri, apiVersion, filter).map(new Func1<ServiceResponse<List<UsageMetricInner>>, List<UsageMetricInner>>() {
            @Override
            public List<UsageMetricInner> call(ServiceResponse<List<UsageMetricInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * The List operation lists the usage metrics for the resource.&lt;br&gt;**WARNING**: This operation will be *deprecated* in the next release.
     *
     * @param resourceUri The identifier of the resource.
     * @param apiVersion Client Api Version. NOTE: This is not a client property, it must be explicit in the call and there is no default value.
     * @param filter The filter to apply on the operation.&lt;br&gt;**WARNING**: $filter not documented since the operation will be deprecated in the next release.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;UsageMetricInner&gt; object
     */
    public Observable<ServiceResponse<List<UsageMetricInner>>> listWithServiceResponseAsync(String resourceUri, String apiVersion, String filter) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return service.list(resourceUri, apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<UsageMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageMetricInner>> result = listDelegate(response);
                        ServiceResponse<List<UsageMetricInner>> clientResponse = new ServiceResponse<List<UsageMetricInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageMetricInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageMetricInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageMetricInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
