/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.Map;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An alert status properties.
 */
public class MetricAlertStatusProperties {
    /**
     * An object describing the type of the dimensions.
     */
    @JsonProperty(value = "dimensions")
    private Map<String, String> dimensions;

    /**
     * status value.
     */
    @JsonProperty(value = "status")
    private String status;

    /**
     * UTC time when the status was checked.
     */
    @JsonProperty(value = "timestamp")
    private DateTime timestamp;

    /**
     * Get an object describing the type of the dimensions.
     *
     * @return the dimensions value
     */
    public Map<String, String> dimensions() {
        return this.dimensions;
    }

    /**
     * Set an object describing the type of the dimensions.
     *
     * @param dimensions the dimensions value to set
     * @return the MetricAlertStatusProperties object itself.
     */
    public MetricAlertStatusProperties withDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get status value.
     *
     * @return the status value
     */
    public String status() {
        return this.status;
    }

    /**
     * Set status value.
     *
     * @param status the status value to set
     * @return the MetricAlertStatusProperties object itself.
     */
    public MetricAlertStatusProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get uTC time when the status was checked.
     *
     * @return the timestamp value
     */
    public DateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set uTC time when the status was checked.
     *
     * @param timestamp the timestamp value to set
     * @return the MetricAlertStatusProperties object itself.
     */
    public MetricAlertStatusProperties withTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

}
