/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import java.util.List;
import org.joda.time.Period;
import com.microsoft.azure.management.monitor.MetricAlertCriteria;
import com.microsoft.azure.management.monitor.MetricAlertAction;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * The metric alert resource.
 */
@JsonFlatten
public class MetricAlertResourceInner extends Resource {
    /**
     * the description of the metric alert that will be included in the alert
     * email.
     */
    @JsonProperty(value = "properties.description", required = true)
    private String description;

    /**
     * Alert severity {0, 1, 2, 3, 4}.
     */
    @JsonProperty(value = "properties.severity", required = true)
    private int severity;

    /**
     * the flag that indicates whether the metric alert is enabled.
     */
    @JsonProperty(value = "properties.enabled", required = true)
    private boolean enabled;

    /**
     * the list of resource id's that this metric alert is scoped to.
     */
    @JsonProperty(value = "properties.scopes")
    private List<String> scopes;

    /**
     * how often the metric alert is evaluated represented in ISO 8601 duration
     * format.
     */
    @JsonProperty(value = "properties.evaluationFrequency", required = true)
    private Period evaluationFrequency;

    /**
     * the period of time (in ISO 8601 duration format) that is used to monitor
     * alert activity based on the threshold.
     */
    @JsonProperty(value = "properties.windowSize", required = true)
    private Period windowSize;

    /**
     * the resource type of the target resource(s) on which the alert is
     * created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     */
    @JsonProperty(value = "properties.targetResourceType")
    private String targetResourceType;

    /**
     * the region of the target resource(s) on which the alert is
     * created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     */
    @JsonProperty(value = "properties.targetResourceRegion")
    private String targetResourceRegion;

    /**
     * defines the specific alert criteria information.
     */
    @JsonProperty(value = "properties.criteria", required = true)
    private MetricAlertCriteria criteria;

    /**
     * the flag that indicates whether the alert should be auto resolved or
     * not.
     */
    @JsonProperty(value = "properties.autoMitigate")
    private Boolean autoMitigate;

    /**
     * the array of actions that are performed when the alert rule becomes
     * active, and when an alert condition is resolved.
     */
    @JsonProperty(value = "properties.actions")
    private List<MetricAlertAction> actions;

    /**
     * Last time the rule was updated in ISO8601 format.
     */
    @JsonProperty(value = "properties.lastUpdatedTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastUpdatedTime;

    /**
     * Get the description of the metric alert that will be included in the alert email.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description of the metric alert that will be included in the alert email.
     *
     * @param description the description value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get alert severity {0, 1, 2, 3, 4}.
     *
     * @return the severity value
     */
    public int severity() {
        return this.severity;
    }

    /**
     * Set alert severity {0, 1, 2, 3, 4}.
     *
     * @param severity the severity value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    /**
     * Get the flag that indicates whether the metric alert is enabled.
     *
     * @return the enabled value
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the flag that indicates whether the metric alert is enabled.
     *
     * @param enabled the enabled value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the list of resource id's that this metric alert is scoped to.
     *
     * @return the scopes value
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the list of resource id's that this metric alert is scoped to.
     *
     * @param scopes the scopes value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get how often the metric alert is evaluated represented in ISO 8601 duration format.
     *
     * @return the evaluationFrequency value
     */
    public Period evaluationFrequency() {
        return this.evaluationFrequency;
    }

    /**
     * Set how often the metric alert is evaluated represented in ISO 8601 duration format.
     *
     * @param evaluationFrequency the evaluationFrequency value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withEvaluationFrequency(Period evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    /**
     * Get the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     *
     * @return the windowSize value
     */
    public Period windowSize() {
        return this.windowSize;
    }

    /**
     * Set the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     *
     * @param windowSize the windowSize value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withWindowSize(Period windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Get the resource type of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @return the targetResourceType value
     */
    public String targetResourceType() {
        return this.targetResourceType;
    }

    /**
     * Set the resource type of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @param targetResourceType the targetResourceType value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    /**
     * Get the region of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @return the targetResourceRegion value
     */
    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    /**
     * Set the region of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
     *
     * @param targetResourceRegion the targetResourceRegion value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    /**
     * Get defines the specific alert criteria information.
     *
     * @return the criteria value
     */
    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set defines the specific alert criteria information.
     *
     * @param criteria the criteria value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Get the flag that indicates whether the alert should be auto resolved or not.
     *
     * @return the autoMitigate value
     */
    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    /**
     * Set the flag that indicates whether the alert should be auto resolved or not.
     *
     * @param autoMitigate the autoMitigate value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    /**
     * Get the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     *
     * @return the actions value
     */
    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    /**
     * Set the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     *
     * @param actions the actions value to set
     * @return the MetricAlertResourceInner object itself.
     */
    public MetricAlertResourceInner withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get last time the rule was updated in ISO8601 format.
     *
     * @return the lastUpdatedTime value
     */
    public DateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

}
