/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Information about a container with data for a given resource.
 */
public class DataContainer {
    /**
     * Log Analytics workspace information.
     */
    @JsonProperty(value = "workspace", required = true)
    private WorkspaceInfo workspace;

    /**
     * Get log Analytics workspace information.
     *
     * @return the workspace value
     */
    public WorkspaceInfo workspace() {
        return this.workspace;
    }

    /**
     * Set log Analytics workspace information.
     *
     * @param workspace the workspace value to set
     * @return the DataContainer object itself.
     */
    public DataContainer withWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
        return this;
    }

}
