/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;

/**
 * Specifies the metric alert criteria for multiple resource that has multiple
 * metric criteria.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "odata.type")
@JsonTypeName("Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
@JsonTypeResolver(OdataTypeDiscriminatorTypeResolver.class)
public class MetricAlertMultipleResourceMultipleMetricCriteria extends MetricAlertCriteria {
    /**
     * the list of multiple metric criteria for this 'all of' operation.
     */
    @JsonProperty(value = "allOf")
    private List<MultiMetricCriteria> allOf;

    /**
     * Get the list of multiple metric criteria for this 'all of' operation.
     *
     * @return the allOf value
     */
    public List<MultiMetricCriteria> allOf() {
        return this.allOf;
    }

    /**
     * Set the list of multiple metric criteria for this 'all of' operation.
     *
     * @param allOf the allOf value to set
     * @return the MetricAlertMultipleResourceMultipleMetricCriteria object itself.
     */
    public MetricAlertMultipleResourceMultipleMetricCriteria withAllOf(List<MultiMetricCriteria> allOf) {
        this.allOf = allOf;
        return this;
    }

}
