/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ResponseWithErrorException;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.VMInsightsOnboardingStatusInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VMInsightsInner {
    private VMInsightsService service;
    private MonitorManagementClientImpl client;

    public VMInsightsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (VMInsightsService)retrofit.create(VMInsightsService.class);
        this.client = client;
    }

    public VMInsightsOnboardingStatusInner getOnboardingStatus(String resourceUri) {
        return (VMInsightsOnboardingStatusInner)((Object)((ServiceResponse)this.getOnboardingStatusWithServiceResponseAsync(resourceUri).toBlocking().single()).body());
    }

    public ServiceFuture<VMInsightsOnboardingStatusInner> getOnboardingStatusAsync(String resourceUri, ServiceCallback<VMInsightsOnboardingStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getOnboardingStatusWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<VMInsightsOnboardingStatusInner> getOnboardingStatusAsync(String resourceUri) {
        return this.getOnboardingStatusWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<VMInsightsOnboardingStatusInner>, VMInsightsOnboardingStatusInner>(){

            public VMInsightsOnboardingStatusInner call(ServiceResponse<VMInsightsOnboardingStatusInner> response) {
                return (VMInsightsOnboardingStatusInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VMInsightsOnboardingStatusInner>> getOnboardingStatusWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2018-11-27-preview";
        return this.service.getOnboardingStatus(resourceUri, "2018-11-27-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VMInsightsOnboardingStatusInner>>>(){

            public Observable<ServiceResponse<VMInsightsOnboardingStatusInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VMInsightsInner.this.getOnboardingStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VMInsightsOnboardingStatusInner> getOnboardingStatusDelegate(Response<ResponseBody> response) throws ResponseWithErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VMInsightsOnboardingStatusInner>(){}.getType()).registerError(ResponseWithErrorException.class).build(response);
    }

    static interface VMInsightsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.VMInsights getOnboardingStatus"})
        @GET(value="{resourceUri}/providers/Microsoft.Insights/vmInsightsOnboardingStatuses/default")
        public Observable<Response<ResponseBody>> getOnboardingStatus(@Path(value="resourceUri", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

