/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure action group.
 */
public class AzNsActionGroup {
    /**
     * Azure Action Group reference.
     */
    @JsonProperty(value = "actionGroup")
    private List<String> actionGroup;

    /**
     * Custom subject override for all email ids in Azure action group.
     */
    @JsonProperty(value = "emailSubject")
    private String emailSubject;

    /**
     * Custom payload to be sent for all webhook URI in Azure action group.
     */
    @JsonProperty(value = "customWebhookPayload")
    private String customWebhookPayload;

    /**
     * Get azure Action Group reference.
     *
     * @return the actionGroup value
     */
    public List<String> actionGroup() {
        return this.actionGroup;
    }

    /**
     * Set azure Action Group reference.
     *
     * @param actionGroup the actionGroup value to set
     * @return the AzNsActionGroup object itself.
     */
    public AzNsActionGroup withActionGroup(List<String> actionGroup) {
        this.actionGroup = actionGroup;
        return this;
    }

    /**
     * Get custom subject override for all email ids in Azure action group.
     *
     * @return the emailSubject value
     */
    public String emailSubject() {
        return this.emailSubject;
    }

    /**
     * Set custom subject override for all email ids in Azure action group.
     *
     * @param emailSubject the emailSubject value to set
     * @return the AzNsActionGroup object itself.
     */
    public AzNsActionGroup withEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
        return this;
    }

    /**
     * Get custom payload to be sent for all webhook URI in Azure action group.
     *
     * @return the customWebhookPayload value
     */
    public String customWebhookPayload() {
        return this.customWebhookPayload;
    }

    /**
     * Set custom payload to be sent for all webhook URI in Azure action group.
     *
     * @param customWebhookPayload the customWebhookPayload value to set
     * @return the AzNsActionGroup object itself.
     */
    public AzNsActionGroup withCustomWebhookPayload(String customWebhookPayload) {
        this.customWebhookPayload = customWebhookPayload;
        return this;
    }

}
