/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ResponseWithErrorException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VMInsights.
 */
public class VMInsightsInner {
    /** The Retrofit service to perform REST calls. */
    private VMInsightsService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of VMInsightsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VMInsightsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(VMInsightsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VMInsights to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VMInsightsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.VMInsights getOnboardingStatus" })
        @GET("{resourceUri}/providers/Microsoft.Insights/vmInsightsOnboardingStatuses/default")
        Observable<Response<ResponseBody>> getOnboardingStatus(@Path(value = "resourceUri", encoded = true) String resourceUri, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the VM Insights onboarding status for the specified resource or resource scope.
     *
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource, or scope, whose status to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ResponseWithErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VMInsightsOnboardingStatusInner object if successful.
     */
    public VMInsightsOnboardingStatusInner getOnboardingStatus(String resourceUri) {
        return getOnboardingStatusWithServiceResponseAsync(resourceUri).toBlocking().single().body();
    }

    /**
     * Retrieves the VM Insights onboarding status for the specified resource or resource scope.
     *
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource, or scope, whose status to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VMInsightsOnboardingStatusInner> getOnboardingStatusAsync(String resourceUri, final ServiceCallback<VMInsightsOnboardingStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(getOnboardingStatusWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    /**
     * Retrieves the VM Insights onboarding status for the specified resource or resource scope.
     *
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource, or scope, whose status to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VMInsightsOnboardingStatusInner object
     */
    public Observable<VMInsightsOnboardingStatusInner> getOnboardingStatusAsync(String resourceUri) {
        return getOnboardingStatusWithServiceResponseAsync(resourceUri).map(new Func1<ServiceResponse<VMInsightsOnboardingStatusInner>, VMInsightsOnboardingStatusInner>() {
            @Override
            public VMInsightsOnboardingStatusInner call(ServiceResponse<VMInsightsOnboardingStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the VM Insights onboarding status for the specified resource or resource scope.
     *
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource, or scope, whose status to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VMInsightsOnboardingStatusInner object
     */
    public Observable<ServiceResponse<VMInsightsOnboardingStatusInner>> getOnboardingStatusWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        final String apiVersion = "2018-11-27-preview";
        return service.getOnboardingStatus(resourceUri, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VMInsightsOnboardingStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<VMInsightsOnboardingStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VMInsightsOnboardingStatusInner> clientResponse = getOnboardingStatusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VMInsightsOnboardingStatusInner> getOnboardingStatusDelegate(Response<ResponseBody> response) throws ResponseWithErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VMInsightsOnboardingStatusInner, ResponseWithErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VMInsightsOnboardingStatusInner>() { }.getType())
                .registerError(ResponseWithErrorException.class)
                .build(response);
    }

}
