/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.DiagnosticSetting;
import com.microsoft.azure.management.monitor.DiagnosticSettings;
import com.microsoft.azure.management.monitor.DiagnosticSettingsCategory;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingImpl;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsCategoryImpl;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsCategoryResourceCollectionInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsCategoryResourceInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsResourceCollectionInner;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.RXMapper;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class DiagnosticSettingsImpl
extends CreatableResourcesImpl<DiagnosticSetting, DiagnosticSettingImpl, DiagnosticSettingsResourceInner>
implements DiagnosticSettings {
    private final MonitorManager manager;

    DiagnosticSettingsImpl(MonitorManager manager) {
        this.manager = manager;
    }

    public DiagnosticSettingImpl define(String name) {
        return this.wrapModel(name);
    }

    protected DiagnosticSettingImpl wrapModel(String name) {
        DiagnosticSettingsResourceInner inner = new DiagnosticSettingsResourceInner();
        return new DiagnosticSettingImpl(name, inner, this.manager());
    }

    protected DiagnosticSettingImpl wrapModel(DiagnosticSettingsResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new DiagnosticSettingImpl(inner.name(), inner, this.manager());
    }

    public MonitorManager manager() {
        return this.manager;
    }

    public DiagnosticSettingsInner inner() {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings();
    }

    @Override
    public List<DiagnosticSettingsCategory> listCategoriesByResource(String resourceId) {
        ArrayList<DiagnosticSettingsCategory> categories = new ArrayList<DiagnosticSettingsCategory>();
        DiagnosticSettingsCategoryResourceCollectionInner collection = ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettingsCategorys().list(resourceId);
        if (collection != null) {
            for (DiagnosticSettingsCategoryResourceInner category : collection.value()) {
                categories.add(new DiagnosticSettingsCategoryImpl(category));
            }
        }
        return categories;
    }

    @Override
    public Observable<DiagnosticSettingsCategory> listCategoriesByResourceAsync(String resourceId) {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettingsCategorys().listAsync(resourceId).flatMap((Func1)new Func1<DiagnosticSettingsCategoryResourceCollectionInner, Observable<DiagnosticSettingsCategoryResourceInner>>(){

            public Observable<DiagnosticSettingsCategoryResourceInner> call(DiagnosticSettingsCategoryResourceCollectionInner diagnosticSettingsCategoryResourceCollectionInner) {
                return Observable.from(diagnosticSettingsCategoryResourceCollectionInner.value());
            }
        }).map((Func1)new Func1<DiagnosticSettingsCategoryResourceInner, DiagnosticSettingsCategory>(){

            public DiagnosticSettingsCategory call(DiagnosticSettingsCategoryResourceInner diagnosticSettingsCategoryInner) {
                return new DiagnosticSettingsCategoryImpl(diagnosticSettingsCategoryInner);
            }
        });
    }

    @Override
    public DiagnosticSettingsCategory getCategory(String resourceId, String name) {
        return new DiagnosticSettingsCategoryImpl(((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettingsCategorys().get(resourceId, name));
    }

    @Override
    public Observable<DiagnosticSettingsCategory> getCategoryAsync(String resourceId, String name) {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettingsCategorys().getAsync(resourceId, name).map((Func1)new Func1<DiagnosticSettingsCategoryResourceInner, DiagnosticSettingsCategory>(){

            public DiagnosticSettingsCategory call(DiagnosticSettingsCategoryResourceInner diagnosticSettingsCategoryResourceInner) {
                return new DiagnosticSettingsCategoryImpl(diagnosticSettingsCategoryResourceInner);
            }
        });
    }

    @Override
    public PagedList<DiagnosticSetting> listByResource(String resourceId) {
        DiagnosticSettingsResourceCollectionInner result = ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().list(resourceId);
        if (result == null) {
            return null;
        }
        return this.wrapList(result.value());
    }

    @Override
    public Observable<DiagnosticSetting> listByResourceAsync(String resourceId) {
        final DiagnosticSettingsImpl self = this;
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().listAsync(resourceId).flatMap((Func1)new Func1<DiagnosticSettingsResourceCollectionInner, Observable<DiagnosticSettingsResourceInner>>(){

            public Observable<DiagnosticSettingsResourceInner> call(DiagnosticSettingsResourceCollectionInner diagnosticSettingsResourceCollectionInner) {
                return Observable.from(diagnosticSettingsResourceCollectionInner.value());
            }
        }).map((Func1)new Func1<DiagnosticSettingsResourceInner, DiagnosticSetting>(){

            public DiagnosticSetting call(DiagnosticSettingsResourceInner diagnosticSettingInner) {
                return new DiagnosticSettingImpl(diagnosticSettingInner.name(), diagnosticSettingInner, self.manager());
            }
        });
    }

    @Override
    public void delete(String resourceId, String name) {
        ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().delete(resourceId, name);
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceId, String name, ServiceCallback<Void> callback) {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().deleteAsync(resourceId, name, callback);
    }

    @Override
    public Completable deleteAsync(String resourceId, String name) {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().deleteAsync(resourceId, name).toCompletable();
    }

    @Override
    public DiagnosticSetting get(String resourceId, String name) {
        return this.wrapModel(((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().get(resourceId, name));
    }

    @Override
    public Observable<DiagnosticSetting> getAsync(String resourceId, String name) {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().getAsync(resourceId, name).map((Func1)new Func1<DiagnosticSettingsResourceInner, DiagnosticSetting>(){

            public DiagnosticSetting call(DiagnosticSettingsResourceInner diagnosticSettingsResourceInner) {
                return DiagnosticSettingsImpl.this.wrapModel(diagnosticSettingsResourceInner);
            }
        });
    }

    public Completable deleteByIdAsync(String id) {
        return ((MonitorManagementClientImpl)((Object)this.manager().inner())).diagnosticSettings().deleteAsync(this.getResourceIdFromSettingsId(id), this.getNameFromSettingsId(id)).toCompletable();
    }

    public Observable<String> deleteByIdsAsync(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Observable.empty();
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String id : ids) {
            String resourceGroupName = this.getResourceIdFromSettingsId(id);
            String name = this.getNameFromSettingsId(id);
            Observable o = RXMapper.map(this.inner().deleteAsync(resourceGroupName, name), (Object)id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }

    public Observable<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).toBlocking().last();
        }
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    public DiagnosticSetting getById(String id) {
        return this.wrapModel(this.inner().get(this.getResourceIdFromSettingsId(id), this.getNameFromSettingsId(id)));
    }

    public Observable<DiagnosticSetting> getByIdAsync(String id) {
        return this.inner().getAsync(this.getResourceIdFromSettingsId(id), this.getNameFromSettingsId(id)).map((Func1)new Func1<DiagnosticSettingsResourceInner, DiagnosticSetting>(){

            public DiagnosticSetting call(DiagnosticSettingsResourceInner diagnosticSettingsResourceInner) {
                return DiagnosticSettingsImpl.this.wrapModel(diagnosticSettingsResourceInner);
            }
        });
    }

    public ServiceFuture<DiagnosticSetting> getByIdAsync(String id, ServiceCallback<DiagnosticSetting> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    private String getResourceIdFromSettingsId(String diagnosticSettingId) {
        if (diagnosticSettingId == null) {
            throw new IllegalArgumentException("Parameter 'resourceId' is required and cannot be null.");
        }
        int dsIdx = diagnosticSettingId.lastIndexOf("/providers/microsoft.insights/diagnosticSettings/");
        if (dsIdx == -1) {
            throw new IllegalArgumentException("Parameter 'resourceId' does not represent a valid Diagnostic Settings resource Id [" + diagnosticSettingId + "].");
        }
        return diagnosticSettingId.substring(0, dsIdx);
    }

    private String getNameFromSettingsId(String diagnosticSettingId) {
        String resourceId = this.getResourceIdFromSettingsId(diagnosticSettingId);
        return diagnosticSettingId.substring(resourceId.length() + "/providers/microsoft.insights/diagnosticSettings/".length());
    }
}

