/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Criterion for dynamic threshold.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "criterionType")
@JsonTypeName("DynamicThresholdCriterion")
public class DynamicMetricCriteria extends MultiMetricCriteria {
    /**
     * The operator used to compare the metric value against the threshold.
     */
    @JsonProperty(value = "operator", required = true)
    private Object operator;

    /**
     * The extent of deviation required to trigger an alert. This will affect
     * how tight the threshold is to the metric series pattern.
     */
    @JsonProperty(value = "alertSensitivity", required = true)
    private Object alertSensitivity;

    /**
     * The minimum number of violations required within the selected lookback
     * time window required to raise an alert.
     */
    @JsonProperty(value = "failingPeriods", required = true)
    private DynamicThresholdFailingPeriods failingPeriods;

    /**
     * Use this option to set the date from which to start learning the metric
     * historical data and calculate the dynamic thresholds (in ISO8601
     * format).
     */
    @JsonProperty(value = "ignoreDataBefore")
    private DateTime ignoreDataBefore;

    /**
     * Get the operator used to compare the metric value against the threshold.
     *
     * @return the operator value
     */
    public Object operator() {
        return this.operator;
    }

    /**
     * Set the operator used to compare the metric value against the threshold.
     *
     * @param operator the operator value to set
     * @return the DynamicMetricCriteria object itself.
     */
    public DynamicMetricCriteria withOperator(Object operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
     *
     * @return the alertSensitivity value
     */
    public Object alertSensitivity() {
        return this.alertSensitivity;
    }

    /**
     * Set the extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
     *
     * @param alertSensitivity the alertSensitivity value to set
     * @return the DynamicMetricCriteria object itself.
     */
    public DynamicMetricCriteria withAlertSensitivity(Object alertSensitivity) {
        this.alertSensitivity = alertSensitivity;
        return this;
    }

    /**
     * Get the minimum number of violations required within the selected lookback time window required to raise an alert.
     *
     * @return the failingPeriods value
     */
    public DynamicThresholdFailingPeriods failingPeriods() {
        return this.failingPeriods;
    }

    /**
     * Set the minimum number of violations required within the selected lookback time window required to raise an alert.
     *
     * @param failingPeriods the failingPeriods value to set
     * @return the DynamicMetricCriteria object itself.
     */
    public DynamicMetricCriteria withFailingPeriods(DynamicThresholdFailingPeriods failingPeriods) {
        this.failingPeriods = failingPeriods;
        return this;
    }

    /**
     * Get use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format).
     *
     * @return the ignoreDataBefore value
     */
    public DateTime ignoreDataBefore() {
        return this.ignoreDataBefore;
    }

    /**
     * Set use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format).
     *
     * @param ignoreDataBefore the ignoreDataBefore value to set
     * @return the DynamicMetricCriteria object itself.
     */
    public DynamicMetricCriteria withIgnoreDataBefore(DateTime ignoreDataBefore) {
        this.ignoreDataBefore = ignoreDataBefore;
        return this;
    }

}
