/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.ResultType;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.Period;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Baselines.
 */
public class BaselinesInner {
    /** The Retrofit service to perform REST calls. */
    private BaselinesService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of BaselinesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public BaselinesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(BaselinesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Baselines to be
     * used by Retrofit to perform actually REST calls.
     */
    interface BaselinesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.Baselines list" })
        @GET("{resourceUri}/providers/microsoft.insights/metricBaselines")
        Observable<Response<ResponseBody>> list(@Path(value = "resourceUri", encoded = true) String resourceUri, @Query("metricnames") String metricnames, @Query("metricnamespace") String metricnamespace, @Query("timespan") String timespan, @Query("interval") Period interval, @Query("aggregation") String aggregation, @Query("sensitivities") String sensitivities, @Query("$filter") String filter, @Query("resultType") ResultType resultType1, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SingleMetricBaselineInner&gt; object if successful.
     */
    public List<SingleMetricBaselineInner> list(String resourceUri) {
        return listWithServiceResponseAsync(resourceUri).toBlocking().single().body();
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SingleMetricBaselineInner>> listAsync(String resourceUri, final ServiceCallback<List<SingleMetricBaselineInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SingleMetricBaselineInner&gt; object
     */
    public Observable<List<SingleMetricBaselineInner>> listAsync(String resourceUri) {
        return listWithServiceResponseAsync(resourceUri).map(new Func1<ServiceResponse<List<SingleMetricBaselineInner>>, List<SingleMetricBaselineInner>>() {
            @Override
            public List<SingleMetricBaselineInner> call(ServiceResponse<List<SingleMetricBaselineInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SingleMetricBaselineInner&gt; object
     */
    public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        final String apiVersion = "2019-03-01";
        final String metricnames = null;
        final String metricnamespace = null;
        final String timespan = null;
        final Period interval = null;
        final String aggregation = null;
        final String sensitivities = null;
        final String filter = null;
        final ResultType resultType = null;
        return service.list(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SingleMetricBaselineInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SingleMetricBaselineInner>> result = listDelegate(response);
                        List<SingleMetricBaselineInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SingleMetricBaselineInner>> clientResponse = new ServiceResponse<List<SingleMetricBaselineInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param metricnamespace Metric namespace to query metric definitions for.
     * @param timespan The timespan of the query. It is a string with the following format 'startDateTime_ISO/endDateTime_ISO'.
     * @param interval The interval (i.e. timegrain) of the query.
     * @param aggregation The list of aggregation types (comma separated) to retrieve.
     * @param sensitivities The list of sensitivities (comma separated) to retrieve.
     * @param filter The **$filter** is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or b2&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid variant:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time series where A = a1, B = b1 and C = c1:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;- Return all time series where A = a1&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param resultType Allows retrieving only metadata of the baseline. On data request all information is retrieved. Possible values include: 'Data', 'Metadata'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;SingleMetricBaselineInner&gt; object if successful.
     */
    public List<SingleMetricBaselineInner> list(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        return listWithServiceResponseAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType).toBlocking().single().body();
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param metricnamespace Metric namespace to query metric definitions for.
     * @param timespan The timespan of the query. It is a string with the following format 'startDateTime_ISO/endDateTime_ISO'.
     * @param interval The interval (i.e. timegrain) of the query.
     * @param aggregation The list of aggregation types (comma separated) to retrieve.
     * @param sensitivities The list of sensitivities (comma separated) to retrieve.
     * @param filter The **$filter** is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or b2&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid variant:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time series where A = a1, B = b1 and C = c1:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;- Return all time series where A = a1&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param resultType Allows retrieving only metadata of the baseline. On data request all information is retrieved. Possible values include: 'Data', 'Metadata'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SingleMetricBaselineInner>> listAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType, final ServiceCallback<List<SingleMetricBaselineInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType), serviceCallback);
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param metricnamespace Metric namespace to query metric definitions for.
     * @param timespan The timespan of the query. It is a string with the following format 'startDateTime_ISO/endDateTime_ISO'.
     * @param interval The interval (i.e. timegrain) of the query.
     * @param aggregation The list of aggregation types (comma separated) to retrieve.
     * @param sensitivities The list of sensitivities (comma separated) to retrieve.
     * @param filter The **$filter** is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or b2&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid variant:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time series where A = a1, B = b1 and C = c1:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;- Return all time series where A = a1&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param resultType Allows retrieving only metadata of the baseline. On data request all information is retrieved. Possible values include: 'Data', 'Metadata'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SingleMetricBaselineInner&gt; object
     */
    public Observable<List<SingleMetricBaselineInner>> listAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        return listWithServiceResponseAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType).map(new Func1<ServiceResponse<List<SingleMetricBaselineInner>>, List<SingleMetricBaselineInner>>() {
            @Override
            public List<SingleMetricBaselineInner> call(ServiceResponse<List<SingleMetricBaselineInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * **Lists the metric baseline values for a resource**.
     *
     * @param resourceUri The identifier of the resource.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param metricnamespace Metric namespace to query metric definitions for.
     * @param timespan The timespan of the query. It is a string with the following format 'startDateTime_ISO/endDateTime_ISO'.
     * @param interval The interval (i.e. timegrain) of the query.
     * @param aggregation The list of aggregation types (comma separated) to retrieve.
     * @param sensitivities The list of sensitivities (comma separated) to retrieve.
     * @param filter The **$filter** is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or b2&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid variant:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time series where A = a1, B = b1 and C = c1:&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;- Return all time series where A = a1&lt;br&gt;**$filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param resultType Allows retrieving only metadata of the baseline. On data request all information is retrieved. Possible values include: 'Data', 'Metadata'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;SingleMetricBaselineInner&gt; object
     */
    public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> listWithServiceResponseAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        final String apiVersion = "2019-03-01";
        return service.list(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SingleMetricBaselineInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SingleMetricBaselineInner>> result = listDelegate(response);
                        List<SingleMetricBaselineInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<SingleMetricBaselineInner>> clientResponse = new ServiceResponse<List<SingleMetricBaselineInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SingleMetricBaselineInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SingleMetricBaselineInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SingleMetricBaselineInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
