/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in EventCategories.
 */
public class EventCategoriesInner {
    /** The Retrofit service to perform REST calls. */
    private EventCategoriesService service;
    /** The service client containing this operation class. */
    private MonitorClientImpl client;

    /**
     * Initializes an instance of EventCategoriesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public EventCategoriesInner(Retrofit retrofit, MonitorClientImpl client) {
        this.service = retrofit.create(EventCategoriesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for EventCategories to be
     * used by Retrofit to perform actually REST calls.
     */
    interface EventCategoriesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.EventCategories list" })
        @GET("providers/microsoft.insights/eventcategories")
        Observable<Response<ResponseBody>> list(@Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get the list of available event categories supported in the Activity Logs Service.&lt;br&gt;The current list includes the following: Aministrative, Security, ServiceHealth, Alert, Recommendation, Policy.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;LocalizableStringInner&gt; object if successful.
     */
    public List<LocalizableStringInner> list() {
        return listWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Get the list of available event categories supported in the Activity Logs Service.&lt;br&gt;The current list includes the following: Aministrative, Security, ServiceHealth, Alert, Recommendation, Policy.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<LocalizableStringInner>> listAsync(final ServiceCallback<List<LocalizableStringInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Get the list of available event categories supported in the Activity Logs Service.&lt;br&gt;The current list includes the following: Aministrative, Security, ServiceHealth, Alert, Recommendation, Policy.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;LocalizableStringInner&gt; object
     */
    public Observable<List<LocalizableStringInner>> listAsync() {
        return listWithServiceResponseAsync().map(new Func1<ServiceResponse<List<LocalizableStringInner>>, List<LocalizableStringInner>>() {
            @Override
            public List<LocalizableStringInner> call(ServiceResponse<List<LocalizableStringInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the list of available event categories supported in the Activity Logs Service.&lt;br&gt;The current list includes the following: Aministrative, Security, ServiceHealth, Alert, Recommendation, Policy.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;LocalizableStringInner&gt; object
     */
    public Observable<ServiceResponse<List<LocalizableStringInner>>> listWithServiceResponseAsync() {
        final String apiVersion = "2015-04-01";
        return service.list(apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LocalizableStringInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<LocalizableStringInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<LocalizableStringInner>> result = listDelegate(response);
                        ServiceResponse<List<LocalizableStringInner>> clientResponse = new ServiceResponse<List<LocalizableStringInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<LocalizableStringInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<LocalizableStringInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<LocalizableStringInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
