/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.monitor.SenderAuthorization;
import java.util.Map;
import com.microsoft.azure.management.monitor.HttpRequestInfo;
import com.microsoft.azure.management.monitor.EventLevel;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Azure event log entries are of type EventData.
 */
public class EventDataInner {
    /**
     * The authorization property.
     */
    @JsonProperty(value = "authorization")
    private SenderAuthorization authorization;

    /**
     * key value pairs to identify ARM permissions.
     */
    @JsonProperty(value = "claims")
    private Map<String, String> claims;

    /**
     * the email address of the user who has performed the operation, the UPN
     * claim or SPN claim based on availability.
     */
    @JsonProperty(value = "caller")
    private String caller;

    /**
     * the description of the event.
     */
    @JsonProperty(value = "description")
    private String description;

    /**
     * the Id of this event as required by ARM for RBAC. It contains the
     * EventDataID and a timestamp information.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * the event data Id. This is a unique identifier for an event.
     */
    @JsonProperty(value = "eventDataId")
    private String eventDataId;

    /**
     * the correlation Id, usually a GUID in the string format. The correlation
     * Id is shared among the events that belong to the same uber operation.
     */
    @JsonProperty(value = "correlationId")
    private String correlationId;

    /**
     * the event name. This value should not be confused with OperationName.
     * For practical purposes, OperationName might be more appealing to end
     * users.
     */
    @JsonProperty(value = "eventName")
    private LocalizableStringInner eventName;

    /**
     * the event category.
     */
    @JsonProperty(value = "category")
    private LocalizableStringInner category;

    /**
     * the HTTP request info. Usually includes the 'clientRequestId',
     * 'clientIpAddress' (IP address of the user who initiated the event) and
     * 'method' (HTTP method e.g. PUT).
     */
    @JsonProperty(value = "httpRequest")
    private HttpRequestInfo httpRequest;

    /**
     * the event level. Possible values include: 'Critical', 'Error',
     * 'Warning', 'Informational', 'Verbose'.
     */
    @JsonProperty(value = "level", required = true)
    private EventLevel level;

    /**
     * the resource group name of the impacted resource.
     */
    @JsonProperty(value = "resourceGroupName")
    private String resourceGroupName;

    /**
     * the resource provider name of the impacted resource.
     */
    @JsonProperty(value = "resourceProviderName")
    private LocalizableStringInner resourceProviderName;

    /**
     * the resource uri that uniquely identifies the resource that caused this
     * event.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /**
     * the resource type.
     */
    @JsonProperty(value = "resourceType")
    private LocalizableStringInner resourceType;

    /**
     * It is usually a GUID shared among the events corresponding to single
     * operation. This value should not be confused with EventName.
     */
    @JsonProperty(value = "operationId")
    private String operationId;

    /**
     * the operation name.
     */
    @JsonProperty(value = "operationName")
    private LocalizableStringInner operationName;

    /**
     * the set of &lt;Key, Value&gt; pairs (usually a Dictionary&lt;String,
     * String&gt;) that includes details about the event.
     */
    @JsonProperty(value = "properties")
    private Map<String, String> properties;

    /**
     * a string describing the status of the operation. Some typical values
     * are: Started, In progress, Succeeded, Failed, Resolved.
     */
    @JsonProperty(value = "status")
    private LocalizableStringInner status;

    /**
     * the event sub status. Most of the time, when included, this captures the
     * HTTP status code of the REST call. Common values are: OK (HTTP Status
     * Code: 200), Created (HTTP Status Code: 201), Accepted (HTTP Status Code:
     * 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code:
     * 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code:
     * 409), Internal Server Error (HTTP Status Code: 500), Service Unavailable
     * (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504).
     */
    @JsonProperty(value = "subStatus")
    private LocalizableStringInner subStatus;

    /**
     * the timestamp of when the event was generated by the Azure service
     * processing the request corresponding the event. It in ISO 8601 format.
     */
    @JsonProperty(value = "eventTimestamp", required = true)
    private DateTime eventTimestamp;

    /**
     * the timestamp of when the event became available for querying via this
     * API. It is in ISO 8601 format. This value should not be confused
     * eventTimestamp. As there might be a delay between the occurence time of
     * the event, and the time that the event is submitted to the Azure logging
     * infrastructure.
     */
    @JsonProperty(value = "submissionTimestamp", required = true)
    private DateTime submissionTimestamp;

    /**
     * the Azure subscription Id usually a GUID.
     */
    @JsonProperty(value = "subscriptionId")
    private String subscriptionId;

    /**
     * the Azure tenant Id.
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /**
     * Get the authorization value.
     *
     * @return the authorization value
     */
    public SenderAuthorization authorization() {
        return this.authorization;
    }

    /**
     * Set the authorization value.
     *
     * @param authorization the authorization value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withAuthorization(SenderAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    /**
     * Get the claims value.
     *
     * @return the claims value
     */
    public Map<String, String> claims() {
        return this.claims;
    }

    /**
     * Set the claims value.
     *
     * @param claims the claims value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withClaims(Map<String, String> claims) {
        this.claims = claims;
        return this;
    }

    /**
     * Get the caller value.
     *
     * @return the caller value
     */
    public String caller() {
        return this.caller;
    }

    /**
     * Set the caller value.
     *
     * @param caller the caller value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withCaller(String caller) {
        this.caller = caller;
        return this;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description value.
     *
     * @param description the description value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the eventDataId value.
     *
     * @return the eventDataId value
     */
    public String eventDataId() {
        return this.eventDataId;
    }

    /**
     * Set the eventDataId value.
     *
     * @param eventDataId the eventDataId value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withEventDataId(String eventDataId) {
        this.eventDataId = eventDataId;
        return this;
    }

    /**
     * Get the correlationId value.
     *
     * @return the correlationId value
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId value.
     *
     * @param correlationId the correlationId value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the eventName value.
     *
     * @return the eventName value
     */
    public LocalizableStringInner eventName() {
        return this.eventName;
    }

    /**
     * Set the eventName value.
     *
     * @param eventName the eventName value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withEventName(LocalizableStringInner eventName) {
        this.eventName = eventName;
        return this;
    }

    /**
     * Get the category value.
     *
     * @return the category value
     */
    public LocalizableStringInner category() {
        return this.category;
    }

    /**
     * Set the category value.
     *
     * @param category the category value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withCategory(LocalizableStringInner category) {
        this.category = category;
        return this;
    }

    /**
     * Get the httpRequest value.
     *
     * @return the httpRequest value
     */
    public HttpRequestInfo httpRequest() {
        return this.httpRequest;
    }

    /**
     * Set the httpRequest value.
     *
     * @param httpRequest the httpRequest value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withHttpRequest(HttpRequestInfo httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    /**
     * Get the level value.
     *
     * @return the level value
     */
    public EventLevel level() {
        return this.level;
    }

    /**
     * Set the level value.
     *
     * @param level the level value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withLevel(EventLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the resourceGroupName value.
     *
     * @return the resourceGroupName value
     */
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    /**
     * Set the resourceGroupName value.
     *
     * @param resourceGroupName the resourceGroupName value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    /**
     * Get the resourceProviderName value.
     *
     * @return the resourceProviderName value
     */
    public LocalizableStringInner resourceProviderName() {
        return this.resourceProviderName;
    }

    /**
     * Set the resourceProviderName value.
     *
     * @param resourceProviderName the resourceProviderName value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withResourceProviderName(LocalizableStringInner resourceProviderName) {
        this.resourceProviderName = resourceProviderName;
        return this;
    }

    /**
     * Get the resourceId value.
     *
     * @return the resourceId value
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId value.
     *
     * @param resourceId the resourceId value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the resourceType value.
     *
     * @return the resourceType value
     */
    public LocalizableStringInner resourceType() {
        return this.resourceType;
    }

    /**
     * Set the resourceType value.
     *
     * @param resourceType the resourceType value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withResourceType(LocalizableStringInner resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    /**
     * Get the operationId value.
     *
     * @return the operationId value
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Set the operationId value.
     *
     * @param operationId the operationId value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Get the operationName value.
     *
     * @return the operationName value
     */
    public LocalizableStringInner operationName() {
        return this.operationName;
    }

    /**
     * Set the operationName value.
     *
     * @param operationName the operationName value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withOperationName(LocalizableStringInner operationName) {
        this.operationName = operationName;
        return this;
    }

    /**
     * Get the properties value.
     *
     * @return the properties value
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties value.
     *
     * @param properties the properties value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public LocalizableStringInner status() {
        return this.status;
    }

    /**
     * Set the status value.
     *
     * @param status the status value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withStatus(LocalizableStringInner status) {
        this.status = status;
        return this;
    }

    /**
     * Get the subStatus value.
     *
     * @return the subStatus value
     */
    public LocalizableStringInner subStatus() {
        return this.subStatus;
    }

    /**
     * Set the subStatus value.
     *
     * @param subStatus the subStatus value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withSubStatus(LocalizableStringInner subStatus) {
        this.subStatus = subStatus;
        return this;
    }

    /**
     * Get the eventTimestamp value.
     *
     * @return the eventTimestamp value
     */
    public DateTime eventTimestamp() {
        return this.eventTimestamp;
    }

    /**
     * Set the eventTimestamp value.
     *
     * @param eventTimestamp the eventTimestamp value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withEventTimestamp(DateTime eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    /**
     * Get the submissionTimestamp value.
     *
     * @return the submissionTimestamp value
     */
    public DateTime submissionTimestamp() {
        return this.submissionTimestamp;
    }

    /**
     * Set the submissionTimestamp value.
     *
     * @param submissionTimestamp the submissionTimestamp value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withSubmissionTimestamp(DateTime submissionTimestamp) {
        this.submissionTimestamp = submissionTimestamp;
        return this;
    }

    /**
     * Get the subscriptionId value.
     *
     * @return the subscriptionId value
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId value.
     *
     * @param subscriptionId the subscriptionId value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the tenantId value.
     *
     * @return the tenantId value
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId value.
     *
     * @param tenantId the tenantId value to set
     * @return the EventDataInner object itself.
     */
    public EventDataInner withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

}
