/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import java.util.List;
import com.microsoft.azure.management.monitor.MetricSettings;
import com.microsoft.azure.management.monitor.LogSettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Description of a service diagnostic setting.
 */
@JsonFlatten
public class ServiceDiagnosticSettingsResourceInner extends Resource {
    /**
     * The resource ID of the storage account to which you would like to send
     * Diagnostic Logs.
     */
    @JsonProperty(value = "properties.storageAccountId")
    private String storageAccountId;

    /**
     * The service bus rule ID of the service bus namespace in which you would
     * like to have Event Hubs created for streaming Diagnostic Logs. The rule
     * ID is of the format: '{service bus resource ID}/authorizationrules/{key
     * name}'.
     */
    @JsonProperty(value = "properties.serviceBusRuleId")
    private String serviceBusRuleId;

    /**
     * The resource Id for the event hub authorization rule.
     */
    @JsonProperty(value = "properties.eventHubAuthorizationRuleId")
    private String eventHubAuthorizationRuleId;

    /**
     * the list of metric settings.
     */
    @JsonProperty(value = "properties.metrics")
    private List<MetricSettings> metrics;

    /**
     * the list of logs settings.
     */
    @JsonProperty(value = "properties.logs")
    private List<LogSettings> logs;

    /**
     * The workspace ID (resource ID of a Log Analytics workspace) for a Log
     * Analytics workspace to which you would like to send Diagnostic Logs.
     * Example:
     * /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
     */
    @JsonProperty(value = "properties.workspaceId")
    private String workspaceId;

    /**
     * Get the storageAccountId value.
     *
     * @return the storageAccountId value
     */
    public String storageAccountId() {
        return this.storageAccountId;
    }

    /**
     * Set the storageAccountId value.
     *
     * @param storageAccountId the storageAccountId value to set
     * @return the ServiceDiagnosticSettingsResourceInner object itself.
     */
    public ServiceDiagnosticSettingsResourceInner withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    /**
     * Get the serviceBusRuleId value.
     *
     * @return the serviceBusRuleId value
     */
    public String serviceBusRuleId() {
        return this.serviceBusRuleId;
    }

    /**
     * Set the serviceBusRuleId value.
     *
     * @param serviceBusRuleId the serviceBusRuleId value to set
     * @return the ServiceDiagnosticSettingsResourceInner object itself.
     */
    public ServiceDiagnosticSettingsResourceInner withServiceBusRuleId(String serviceBusRuleId) {
        this.serviceBusRuleId = serviceBusRuleId;
        return this;
    }

    /**
     * Get the eventHubAuthorizationRuleId value.
     *
     * @return the eventHubAuthorizationRuleId value
     */
    public String eventHubAuthorizationRuleId() {
        return this.eventHubAuthorizationRuleId;
    }

    /**
     * Set the eventHubAuthorizationRuleId value.
     *
     * @param eventHubAuthorizationRuleId the eventHubAuthorizationRuleId value to set
     * @return the ServiceDiagnosticSettingsResourceInner object itself.
     */
    public ServiceDiagnosticSettingsResourceInner withEventHubAuthorizationRuleId(String eventHubAuthorizationRuleId) {
        this.eventHubAuthorizationRuleId = eventHubAuthorizationRuleId;
        return this;
    }

    /**
     * Get the metrics value.
     *
     * @return the metrics value
     */
    public List<MetricSettings> metrics() {
        return this.metrics;
    }

    /**
     * Set the metrics value.
     *
     * @param metrics the metrics value to set
     * @return the ServiceDiagnosticSettingsResourceInner object itself.
     */
    public ServiceDiagnosticSettingsResourceInner withMetrics(List<MetricSettings> metrics) {
        this.metrics = metrics;
        return this;
    }

    /**
     * Get the logs value.
     *
     * @return the logs value
     */
    public List<LogSettings> logs() {
        return this.logs;
    }

    /**
     * Set the logs value.
     *
     * @param logs the logs value to set
     * @return the ServiceDiagnosticSettingsResourceInner object itself.
     */
    public ServiceDiagnosticSettingsResourceInner withLogs(List<LogSettings> logs) {
        this.logs = logs;
        return this;
    }

    /**
     * Get the workspaceId value.
     *
     * @return the workspaceId value
     */
    public String workspaceId() {
        return this.workspaceId;
    }

    /**
     * Set the workspaceId value.
     *
     * @param workspaceId the workspaceId value to set
     * @return the ServiceDiagnosticSettingsResourceInner object itself.
     */
    public ServiceDiagnosticSettingsResourceInner withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

}
