/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An alert action.
 */
public class MetricAlertAction {
    /**
     * the id of the action group to use.
     */
    @JsonProperty(value = "actionGroupId")
    private String actionGroupId;

    /**
     * The properties of a webhook object.
     */
    @JsonProperty(value = "webhookProperties")
    private Map<String, String> webhookProperties;

    /**
     * Get the id of the action group to use.
     *
     * @return the actionGroupId value
     */
    public String actionGroupId() {
        return this.actionGroupId;
    }

    /**
     * Set the id of the action group to use.
     *
     * @param actionGroupId the actionGroupId value to set
     * @return the MetricAlertAction object itself.
     */
    public MetricAlertAction withActionGroupId(String actionGroupId) {
        this.actionGroupId = actionGroupId;
        return this;
    }

    /**
     * Get the properties of a webhook object.
     *
     * @return the webhookProperties value
     */
    public Map<String, String> webhookProperties() {
        return this.webhookProperties;
    }

    /**
     * Set the properties of a webhook object.
     *
     * @param webhookProperties the webhookProperties value to set
     * @return the MetricAlertAction object itself.
     */
    public MetricAlertAction withWebhookProperties(Map<String, String> webhookProperties) {
        this.webhookProperties = webhookProperties;
        return this;
    }

}
