/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import org.joda.time.Period;
import java.util.List;
import com.microsoft.azure.management.monitor.TimeSeriesBaseline;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The baseline results of a single metric.
 */
@JsonFlatten
public class SingleMetricBaselineInner {
    /**
     * The metric baseline Id.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * The resource type of the metric baseline resource.
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /**
     * The name of the metric for which the baselines were retrieved.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The timespan for which the data was retrieved. Its value consists of two
     * datetimes concatenated, separated by '/'.  This may be adjusted in the
     * future and returned back from what was originally requested.
     */
    @JsonProperty(value = "properties.timespan", required = true)
    private String timespan;

    /**
     * The interval (window size) for which the metric data was returned in.
     * This may be adjusted in the future and returned back from what was
     * originally requested.  This is not present if a metadata request was
     * made.
     */
    @JsonProperty(value = "properties.interval", required = true)
    private Period interval;

    /**
     * The namespace of the metrics been queried.
     */
    @JsonProperty(value = "properties.namespace")
    private String namespace;

    /**
     * The baseline for each time series that was queried.
     */
    @JsonProperty(value = "properties.baselines", required = true)
    private List<TimeSeriesBaseline> baselines;

    /**
     * Get the metric baseline Id.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the metric baseline Id.
     *
     * @param id the id value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the resource type of the metric baseline resource.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the resource type of the metric baseline resource.
     *
     * @param type the type value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name of the metric for which the baselines were retrieved.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the metric for which the baselines were retrieved.
     *
     * @param name the name value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
     *
     * @return the timespan value
     */
    public String timespan() {
        return this.timespan;
    }

    /**
     * Set the timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
     *
     * @param timespan the timespan value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    /**
     * Get the interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
     *
     * @return the interval value
     */
    public Period interval() {
        return this.interval;
    }

    /**
     * Set the interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
     *
     * @param interval the interval value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withInterval(Period interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the namespace of the metrics been queried.
     *
     * @return the namespace value
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace of the metrics been queried.
     *
     * @param namespace the namespace value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the baseline for each time series that was queried.
     *
     * @return the baselines value
     */
    public List<TimeSeriesBaseline> baselines() {
        return this.baselines;
    }

    /**
     * Set the baseline for each time series that was queried.
     *
     * @param baselines the baselines value to set
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withBaselines(List<TimeSeriesBaseline> baselines) {
        this.baselines = baselines;
        return this;
    }

}
