/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.ResultType;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.azure.management.monitor.implementation.SingleMetricBaselineInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.Period;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class BaselinesInner {
    private BaselinesService service;
    private MonitorManagementClientImpl client;

    public BaselinesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (BaselinesService)retrofit.create(BaselinesService.class);
        this.client = client;
    }

    public List<SingleMetricBaselineInner> list(String resourceUri) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri).toBlocking().single()).body();
    }

    public ServiceFuture<List<SingleMetricBaselineInner>> listAsync(String resourceUri, ServiceCallback<List<SingleMetricBaselineInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<List<SingleMetricBaselineInner>> listAsync(String resourceUri) {
        return this.listWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<List<SingleMetricBaselineInner>>, List<SingleMetricBaselineInner>>(){

            public List<SingleMetricBaselineInner> call(ServiceResponse<List<SingleMetricBaselineInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2019-03-01";
        String metricnames = null;
        String metricnamespace = null;
        String timespan = null;
        Period interval = null;
        String aggregation = null;
        String sensitivities = null;
        String filter = null;
        ResultType resultType = null;
        return this.service.list(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, "2019-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SingleMetricBaselineInner>>>>(){

            public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BaselinesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<SingleMetricBaselineInner> list(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType).toBlocking().single()).body();
    }

    public ServiceFuture<List<SingleMetricBaselineInner>> listAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType, ServiceCallback<List<SingleMetricBaselineInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType), serviceCallback);
    }

    public Observable<List<SingleMetricBaselineInner>> listAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        return this.listWithServiceResponseAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType).map((Func1)new Func1<ServiceResponse<List<SingleMetricBaselineInner>>, List<SingleMetricBaselineInner>>(){

            public List<SingleMetricBaselineInner> call(ServiceResponse<List<SingleMetricBaselineInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> listWithServiceResponseAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Period interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2019-03-01";
        return this.service.list(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, "2019-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SingleMetricBaselineInner>>>>(){

            public Observable<ServiceResponse<List<SingleMetricBaselineInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BaselinesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SingleMetricBaselineInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SingleMetricBaselineInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface BaselinesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.Baselines list"})
        @GET(value="{resourceUri}/providers/microsoft.insights/metricBaselines")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceUri", encoded=true) String var1, @Query(value="metricnames") String var2, @Query(value="metricnamespace") String var3, @Query(value="timespan") String var4, @Query(value="interval") Period var5, @Query(value="aggregation") String var6, @Query(value="sensitivities") String var7, @Query(value="$filter") String var8, @Query(value="resultType") ResultType var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);
    }
}

