/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServiceDiagnosticSettings.
 */
public class ServiceDiagnosticSettingsInner {
    /** The Retrofit service to perform REST calls. */
    private ServiceDiagnosticSettingsService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of ServiceDiagnosticSettingsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServiceDiagnosticSettingsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(ServiceDiagnosticSettingsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServiceDiagnosticSettings to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServiceDiagnosticSettingsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ServiceDiagnosticSettings get" })
        @GET("{resourceUri}/providers/microsoft.insights/diagnosticSettings/service")
        Observable<Response<ResponseBody>> get(@Path("resourceUri") String resourceUri, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ServiceDiagnosticSettings createOrUpdate" })
        @PUT("{resourceUri}/providers/microsoft.insights/diagnosticSettings/service")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceUri") String resourceUri, @Query("api-version") String apiVersion, @Body ServiceDiagnosticSettingsResourceInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ServiceDiagnosticSettings update" })
        @PATCH("{resourceUri}/providers/microsoft.insights/diagnosticSettings/service")
        Observable<Response<ResponseBody>> update(@Path("resourceUri") String resourceUri, @Query("api-version") String apiVersion, @Body ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the active diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceDiagnosticSettingsResourceInner object if successful.
     */
    public ServiceDiagnosticSettingsResourceInner get(String resourceUri) {
        return getWithServiceResponseAsync(resourceUri).toBlocking().single().body();
    }

    /**
     * Gets the active diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceDiagnosticSettingsResourceInner> getAsync(String resourceUri, final ServiceCallback<ServiceDiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    /**
     * Gets the active diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceDiagnosticSettingsResourceInner object
     */
    public Observable<ServiceDiagnosticSettingsResourceInner> getAsync(String resourceUri) {
        return getWithServiceResponseAsync(resourceUri).map(new Func1<ServiceResponse<ServiceDiagnosticSettingsResourceInner>, ServiceDiagnosticSettingsResourceInner>() {
            @Override
            public ServiceDiagnosticSettingsResourceInner call(ServiceResponse<ServiceDiagnosticSettingsResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the active diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceDiagnosticSettingsResourceInner object
     */
    public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> getWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        final String apiVersion = "2016-09-01";
        return service.get(resourceUri, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceDiagnosticSettingsResourceInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceDiagnosticSettingsResourceInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceDiagnosticSettingsResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceDiagnosticSettingsResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update new diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param parameters Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceDiagnosticSettingsResourceInner object if successful.
     */
    public ServiceDiagnosticSettingsResourceInner createOrUpdate(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceUri, parameters).toBlocking().single().body();
    }

    /**
     * Create or update new diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param parameters Parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceDiagnosticSettingsResourceInner> createOrUpdateAsync(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters, final ServiceCallback<ServiceDiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceUri, parameters), serviceCallback);
    }

    /**
     * Create or update new diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param parameters Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceDiagnosticSettingsResourceInner object
     */
    public Observable<ServiceDiagnosticSettingsResourceInner> createOrUpdateAsync(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceUri, parameters).map(new Func1<ServiceResponse<ServiceDiagnosticSettingsResourceInner>, ServiceDiagnosticSettingsResourceInner>() {
            @Override
            public ServiceDiagnosticSettingsResourceInner call(ServiceResponse<ServiceDiagnosticSettingsResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update new diagnostic settings for the specified resource. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param parameters Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceDiagnosticSettingsResourceInner object
     */
    public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceUri, ServiceDiagnosticSettingsResourceInner parameters) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2016-09-01";
        return service.createOrUpdate(resourceUri, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceDiagnosticSettingsResourceInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceDiagnosticSettingsResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceDiagnosticSettingsResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceDiagnosticSettingsResourceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates an existing ServiceDiagnosticSettingsResource. To update other fields use the CreateOrUpdate method. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceDiagnosticSettingsResource Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceDiagnosticSettingsResourceInner object if successful.
     */
    public ServiceDiagnosticSettingsResourceInner update(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource) {
        return updateWithServiceResponseAsync(resourceUri, serviceDiagnosticSettingsResource).toBlocking().single().body();
    }

    /**
     * Updates an existing ServiceDiagnosticSettingsResource. To update other fields use the CreateOrUpdate method. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceDiagnosticSettingsResource Parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceDiagnosticSettingsResourceInner> updateAsync(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource, final ServiceCallback<ServiceDiagnosticSettingsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceUri, serviceDiagnosticSettingsResource), serviceCallback);
    }

    /**
     * Updates an existing ServiceDiagnosticSettingsResource. To update other fields use the CreateOrUpdate method. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceDiagnosticSettingsResource Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceDiagnosticSettingsResourceInner object
     */
    public Observable<ServiceDiagnosticSettingsResourceInner> updateAsync(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource) {
        return updateWithServiceResponseAsync(resourceUri, serviceDiagnosticSettingsResource).map(new Func1<ServiceResponse<ServiceDiagnosticSettingsResourceInner>, ServiceDiagnosticSettingsResourceInner>() {
            @Override
            public ServiceDiagnosticSettingsResourceInner call(ServiceResponse<ServiceDiagnosticSettingsResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing ServiceDiagnosticSettingsResource. To update other fields use the CreateOrUpdate method. **WARNING**: This method will be deprecated in future releases.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceDiagnosticSettingsResource Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceDiagnosticSettingsResourceInner object
     */
    public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> updateWithServiceResponseAsync(String resourceUri, ServiceDiagnosticSettingsResourcePatchInner serviceDiagnosticSettingsResource) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (serviceDiagnosticSettingsResource == null) {
            throw new IllegalArgumentException("Parameter serviceDiagnosticSettingsResource is required and cannot be null.");
        }
        Validator.validate(serviceDiagnosticSettingsResource);
        final String apiVersion = "2016-09-01";
        return service.update(resourceUri, apiVersion, serviceDiagnosticSettingsResource, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceDiagnosticSettingsResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceDiagnosticSettingsResourceInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceDiagnosticSettingsResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceDiagnosticSettingsResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceDiagnosticSettingsResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
