/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.monitor.implementation.ActivityLogsInner;
import com.microsoft.azure.management.monitor.implementation.EventCategoriesInner;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionsInner;
import com.microsoft.azure.management.monitor.implementation.MetricsInner;
import com.microsoft.azure.management.monitor.implementation.TenantActivityLogsInner;
import com.microsoft.azure.management.monitor.implementation.UsageMetricsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class MonitorClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private UsageMetricsInner usageMetrics;
    private EventCategoriesInner eventCategories;
    private ActivityLogsInner activityLogs;
    private TenantActivityLogsInner tenantActivityLogs;
    private MetricDefinitionsInner metricDefinitions;
    private MetricsInner metrics;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public MonitorClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public MonitorClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public MonitorClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public MonitorClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public UsageMetricsInner usageMetrics() {
        return this.usageMetrics;
    }

    public EventCategoriesInner eventCategories() {
        return this.eventCategories;
    }

    public ActivityLogsInner activityLogs() {
        return this.activityLogs;
    }

    public TenantActivityLogsInner tenantActivityLogs() {
        return this.tenantActivityLogs;
    }

    public MetricDefinitionsInner metricDefinitions() {
        return this.metricDefinitions;
    }

    public MetricsInner metrics() {
        return this.metrics;
    }

    public MonitorClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public MonitorClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public MonitorClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.usageMetrics = new UsageMetricsInner(this.restClient().retrofit(), this);
        this.eventCategories = new EventCategoriesInner(this.restClient().retrofit(), this);
        this.activityLogs = new ActivityLogsInner(this.restClient().retrofit(), this);
        this.tenantActivityLogs = new TenantActivityLogsInner(this.restClient().retrofit(), this);
        this.metricDefinitions = new MetricDefinitionsInner(this.restClient().retrofit(), this);
        this.metrics = new MetricsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "MonitorClient");
    }
}

