/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.ResultType;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.ResponseInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.joda.time.Period;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MetricsInner {
    private MetricsService service;
    private MonitorManagementClientImpl client;

    public MetricsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (MetricsService)retrofit.create(MetricsService.class);
        this.client = client;
    }

    public ResponseInner list(String resourceUri) {
        return (ResponseInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri).toBlocking().single()).body();
    }

    public ServiceFuture<ResponseInner> listAsync(String resourceUri, ServiceCallback<ResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<ResponseInner> listAsync(String resourceUri) {
        return this.listWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<ResponseInner>, ResponseInner>(){

            public ResponseInner call(ServiceResponse<ResponseInner> response) {
                return (ResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResponseInner>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2017-05-01-preview";
        String timespan = null;
        Period interval = null;
        String metric = null;
        String aggregation = null;
        Double top = null;
        String orderby = null;
        String filter = null;
        ResultType resultType = null;
        return this.service.list(resourceUri, timespan, interval, metric, aggregation, top, orderby, filter, resultType, "2017-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResponseInner>>>(){

            public Observable<ServiceResponse<ResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ResponseInner list(String resourceUri, String timespan, Period interval, String metric, String aggregation, Double top, String orderby, String filter, ResultType resultType) {
        return (ResponseInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri, timespan, interval, metric, aggregation, top, orderby, filter, resultType).toBlocking().single()).body();
    }

    public ServiceFuture<ResponseInner> listAsync(String resourceUri, String timespan, Period interval, String metric, String aggregation, Double top, String orderby, String filter, ResultType resultType, ServiceCallback<ResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri, timespan, interval, metric, aggregation, top, orderby, filter, resultType), serviceCallback);
    }

    public Observable<ResponseInner> listAsync(String resourceUri, String timespan, Period interval, String metric, String aggregation, Double top, String orderby, String filter, ResultType resultType) {
        return this.listWithServiceResponseAsync(resourceUri, timespan, interval, metric, aggregation, top, orderby, filter, resultType).map((Func1)new Func1<ServiceResponse<ResponseInner>, ResponseInner>(){

            public ResponseInner call(ServiceResponse<ResponseInner> response) {
                return (ResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResponseInner>> listWithServiceResponseAsync(String resourceUri, String timespan, Period interval, String metric, String aggregation, Double top, String orderby, String filter, ResultType resultType) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2017-05-01-preview";
        return this.service.list(resourceUri, timespan, interval, metric, aggregation, top, orderby, filter, resultType, "2017-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResponseInner>>>(){

            public Observable<ServiceResponse<ResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResponseInner> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResponseInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface MetricsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.Metrics list"})
        @GET(value="{resourceUri}/providers/microsoft.insights/metrics")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceUri", encoded=true) String var1, @Query(value="timespan") String var2, @Query(value="interval") Period var3, @Query(value="metric") String var4, @Query(value="aggregation") String var5, @Query(value="$top") Double var6, @Query(value="$orderby") String var7, @Query(value="$filter") String var8, @Query(value="resultType") ResultType var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);
    }
}

