/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.management.monitor;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The baseline values for a single sensitivity value.
 */
public class Baseline {
    /**
     * the sensitivity of the baseline. Possible values include: 'Low',
     * 'Medium', 'High'.
     */
    @JsonProperty(value = "sensitivity", required = true)
    private Sensitivity sensitivity;

    /**
     * The low thresholds of the baseline.
     */
    @JsonProperty(value = "lowThresholds", required = true)
    private List<Double> lowThresholds;

    /**
     * The high thresholds of the baseline.
     */
    @JsonProperty(value = "highThresholds", required = true)
    private List<Double> highThresholds;

    /**
     * Get the sensitivity value.
     *
     * @return the sensitivity value
     */
    public Sensitivity sensitivity() {
        return this.sensitivity;
    }

    /**
     * Set the sensitivity value.
     *
     * @param sensitivity the sensitivity value to set
     * @return the Baseline object itself.
     */
    public Baseline withSensitivity(Sensitivity sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    /**
     * Get the lowThresholds value.
     *
     * @return the lowThresholds value
     */
    public List<Double> lowThresholds() {
        return this.lowThresholds;
    }

    /**
     * Set the lowThresholds value.
     *
     * @param lowThresholds the lowThresholds value to set
     * @return the Baseline object itself.
     */
    public Baseline withLowThresholds(List<Double> lowThresholds) {
        this.lowThresholds = lowThresholds;
        return this;
    }

    /**
     * Get the highThresholds value.
     *
     * @return the highThresholds value
     */
    public List<Double> highThresholds() {
        return this.highThresholds;
    }

    /**
     * Set the highThresholds value.
     *
     * @param highThresholds the highThresholds value to set
     * @return the Baseline object itself.
     */
    public Baseline withHighThresholds(List<Double> highThresholds) {
        this.highThresholds = highThresholds;
        return this;
    }

}
