/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.management.monitor;

import org.joda.time.Period;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * How the data that is collected should be combined over time.
 */
public class ManagementEventAggregationCondition {
    /**
     * the condition operator. Possible values include: 'GreaterThan',
     * 'GreaterThanOrEqual', 'LessThan', 'LessThanOrEqual'.
     */
    @JsonProperty(value = "operator")
    private ConditionOperator operator;

    /**
     * The threshold value that activates the alert.
     */
    @JsonProperty(value = "threshold")
    private Double threshold;

    /**
     * the period of time (in ISO 8601 duration format) that is used to monitor
     * alert activity based on the threshold. If specified then it must be
     * between 5 minutes and 1 day.
     */
    @JsonProperty(value = "windowSize")
    private Period windowSize;

    /**
     * Get the operator value.
     *
     * @return the operator value
     */
    public ConditionOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator value.
     *
     * @param operator the operator value to set
     * @return the ManagementEventAggregationCondition object itself.
     */
    public ManagementEventAggregationCondition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the threshold value.
     *
     * @return the threshold value
     */
    public Double threshold() {
        return this.threshold;
    }

    /**
     * Set the threshold value.
     *
     * @param threshold the threshold value to set
     * @return the ManagementEventAggregationCondition object itself.
     */
    public ManagementEventAggregationCondition withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get the windowSize value.
     *
     * @return the windowSize value
     */
    public Period windowSize() {
        return this.windowSize;
    }

    /**
     * Set the windowSize value.
     *
     * @param windowSize the windowSize value to set
     * @return the ManagementEventAggregationCondition object itself.
     */
    public ManagementEventAggregationCondition withWindowSize(Period windowSize) {
        this.windowSize = windowSize;
        return this;
    }

}
